% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_down_nuts.R
\name{impute_down_nuts}
\alias{impute_down_nuts}
\title{Imputing Data From Larger To Smaller Units in the EU NUTS}
\usage{
impute_down_nuts(
  dat,
  geo_var = "geo",
  values_var = "values",
  method_var = NULL,
  nuts_year = 2016
)
}
\arguments{
\item{dat}{A data frame with exactly two or three columns: \code{geo}
for the geo codes of the units, \code{values} for the values, and
optionally \code{method} for describing the data source.}

\item{geo_var}{The variable that contains the geographical codes in the
NUTS typologies, defaults to code{"geo_var".}}

\item{values_var}{The variable that contains the upstream data to be
imputed to the downstream data, defaults to \code{"values"}.}

\item{method_var}{The variable that contains the metadata on various
processing information, defaults to \code{NULL} in which case it will
be returned as \code{'method'}.}

\item{nuts_year}{The year of the NUTS typology to use, it defaults to the
currently valid \code{2016}.  Alternative values can be any of these:
\code{1999}, \code{2003}, \code{2006}, \code{2010},
\code{2013} and the already
announced and defined \code{2021}. For example, use \code{2013} for
\code{NUTS2013} data.}
}
\value{
An augmented version of the \code{dat} imputed data frame with all
possible projections to valid smaller units, i.e. \code{NUTS0 = country} values
imputed to all missing \code{NUTS1} units, \code{NUTS1} values
imputed to all missing \code{NUTS2} units, \code{NUTS2} values
imputed to all missing \code{NUTS3} units.
}
\description{
This is a special case of \code{\link{impute_down}} for the EU NUTS
hierarchical typologies. All valid actual rows will be projected down
to all smaller constituent typologies where data is missing.
}
\details{
The more general function requires typology information from the higher
and lower level typologies.  This is not needed when the EU vocabulary
is used, and the hierarchy can be established from the EU vocabularies.

Be mindful that while all possible imputations are made, imputations
beyond one hierarchical level will result in very crude estimates.

The imputed dataset \code{dat} must refer to a single time unit, i.e.
panel data is not supported.
}
\examples{
{
data(mixed_nuts_example)
impute_down_nuts(mixed_nuts_example, nuts_year = 2016)
} 
}
\seealso{
Other impute functions: 
\code{\link{impute_down}()}
}
\concept{impute functions}
