% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfdata.R
\name{plot.rfdata}
\alias{plot.rfdata}
\title{Plot function for class rfdata}
\usage{
\method{plot}{rfdata}(x, ..., var = c(1), fun = "mean")
}
\arguments{
\item{x}{an object of \code{rfdata} class.}

\item{...}{other options to pass to the function.}

\item{var}{an integer vector with the indices of variables whose distributions are compared, 
considering the attributes in the order in which they appear in the original data, with the output variable in the last position (default = \code{c(1)}).}

\item{fun}{a character containing the name of the descriptive statistic function to compute for each distribution of the variable, 
or a user-defined function that returns a value from a distribution of numeric values (default: \code{"mean"}). 
Some options for fun include "mean", "median" or "sd" (standard deviation).}
}
\value{
An object of class \code{ggplot} that graphically represents the data distributions before and after the noise filtering.
}
\description{
Graphical representation that allows for comparing data distributions before and after the noise filtering process.
}
\details{
This function generates a plot for each of the variables specified by the \code{var} parameter,
allowing the comparison of their value distributions before filtering, using the descriptive statistic specified by \code{fun},
with the distributions of the data from samples identified as clean and noisy by the filtering method.
}
\examples{
# load the dataset
data(rock)

# apply the regression noise filter
set.seed(9)
output <- regAENN(x = rock[,-ncol(rock)], y = rock[,ncol(rock)])

# comparison chart of data distributions before and after the filtering process
plot(x = output, var = c(1:4), fun = "mean")

}
\seealso{
\code{\link{print.rfdata}}, \code{\link{summary.rfdata}}
}
