% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postprocess.R
\name{postprocess}
\alias{postprocess}
\title{Maximization step.}
\usage{
postprocess(
  estimates,
  item.data,
  pred.data,
  prox.data,
  item_data,
  pred_data,
  prox_data,
  mean_predictors,
  var_predictors,
  item_type,
  tau_vec,
  num_tau,
  alpha,
  pen,
  anchor,
  control,
  final_control,
  final,
  samp_size,
  num_responses,
  num_predictors,
  num_items,
  num_quad,
  NA_cases
)
}
\arguments{
\item{estimates}{List of converged parameters.}

\item{item.data}{User-given matrix or data.frame of DIF and/or impact
predictors.}

\item{pred.data}{User-given matrix or data.frame of item responses.}

\item{prox.data}{User-given matrix or data.frame of observed proxy scores.}

\item{item_data}{Processed matrix or data.frame of item responses.}

\item{pred_data}{Processed matrix or data.frame of DIF and/or impact
predictors.}

\item{prox_data}{Processed matrix or data.frame of observed proxy scores.}

\item{mean_predictors}{Possibly different matrix of predictors for the mean
impact equation.}

\item{var_predictors}{Possibly different matrix of predictors for the
variance impact equation.}

\item{item_type}{Optional character value or vector indicating the type of
item to be modeled.}

\item{tau_vec}{Optional numeric vector of tau values.}

\item{num_tau}{Logical indicating whether the minimum tau value needs to be
identified during the regDIF procedure.}

\item{alpha}{Numeric value indicating the alpha parameter in the elastic net
penalty function.}

\item{pen}{Tuning parameter index.}

\item{anchor}{Anchor item(s).}

\item{control}{Optional list of user-defined control parameters}

\item{final_control}{List of final control parameters.}

\item{final}{List of model results.}

\item{samp_size}{Sample size in dataset.}

\item{num_responses}{Number of responses for each item.}

\item{num_predictors}{Number of predictors.}

\item{num_items}{Number of items in dataset.}

\item{num_quad}{Number of quadrature points used for approximating the
latent variable.}

\item{NA_cases}{Logical vector indicating NA cases.}
}
\value{
a \code{"list"} object of processed \code{"regDIF"} results
}
\description{
Maximization step.
}
\keyword{internal}
