% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lf.vd.R
\docType{data}
\name{sofa}
\alias{sofa}
\title{SOFA (Sequential Organ Failure Assessment) Data}
\format{A data frame with 520 rows (subjects) and 7 variables:
\describe{
  \item{death}{binary indicator that the subject died in the ICU}
  \item{SOFA}{520 x 173 matrix in variable-domain format (a ragged array). 
    Each column represents an ICU day. Each row contains the SOFA scores for
    a subject, one per day, for as long as the subject remained in the ICU.
    The remaining cells of each row are padded with \code{NA}s. SOFA scores
    range from 0 to 24, increasing with severity of organ failure. Missing
    values during one's ICU stay have been imputed using LOCF.}
  \item{SOFA_raw}{Identical to the \code{SOFA} element, except that it contains
    some missing values during one's hospitalization. These missing values
    arise when a subject leaves the ICU temporarily, only to be re-admitted.
    SOFA scores are not monitored outside the ICU.}
  \item{los}{ICU length of stay, i.e., the number of days the patient remained
    in the ICU prior to death or final discharge.}
  \item{age}{Patient age}
  \item{male}{Binary indicator for male gender}
  \item{Charlson}{Charlson co-morbidity index, a measure of baseline health
    status (before hospitalization and ALI).}
}}
\usage{
sofa
}
\description{
A dataset containing the SOFA scores (Vincent et al, 1996). for 520 patients,
hospitalized in the intensive care unit (ICU) with Acute Lung Injury. Daily
measurements are available for as long as each one remains in the ICU. This is an
example of variable-domain functional data, as described by Gellar et al. (2014).
}
\details{
The data was collected as part of the Improving Care of ALI Patients (ICAP)
study (Needham et al., 2006). If you use this dataset as an example in
written work, please cite the study protocol.
}
\references{
Vincent, JL, Moreno, R, Takala, J, Willatts, S, De Mendonca, A,
   Bruining, H, Reinhart, CK, Suter, PM, Thijs, LG (1996). The SOFA ( Sepsis
   related Organ Failure Assessment) score to describe organ
   dysfunction/failure. Intensive Care Medicine, 22(7): 707-710.
   
   Needham, D. M., Dennison, C. R., Dowdy, D. W., Mendez-Tellez, P. A.,
   Ciesla, N., Desai, S. V., Sevransky, J., Shanholtz, C., Scharfstein, D.,
   Herridge, M. S., and Pronovost, P. J. (2006). Study protocol: The
   Improving Care of Acute Lung Injury Patients (ICAP) study. Critical Care
   (London, England), 10(1), R9.
   
   Gellar, Jonathan E., Elizabeth Colantuoni, Dale M. Needham, and
   Ciprian M. Crainiceanu. Variable-Domain Functional Regression for Modeling
   ICU Data. Journal of the American Statistical Association,
   109(508):1425-1439, 2014.
}
\keyword{datasets}
