% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape.H.R
\name{shape.H}
\alias{shape.H}
\title{Creating a Neighborhood Matrix for Areal Data from a Shapefile}
\usage{
shape.H(shape.file)
}
\arguments{
\item{shape.file}{File path to a shapefile.}
}
\value{
A list containing a neighborhood matrix and the SpatialPolygonsDataFrame object
corresponding to the shape file.
    \item{H}{A neighborhood matrix.}
    \item{map}{SpatialPolygonsDataFrame object from the provided shapefile.}
}
\description{
Takes a path to a shape file and creates a neighborhood matrix.  This neighborhood
matrix can be used with the objective ICAR model \insertCite{Keefe_2018}{ref.ICAR}.
}
\examples{
#### Load extra libraries
library(sp)
library(rgdal)

### Read in a shapefile of the contiguous U.S. from package data
system.path <- system.file("extdata", "us.shape48.shp", package = "ref.ICAR", mustWork = TRUE)
shp.layer <- gsub('.shp','',basename(system.path))
shp.path <- dirname(system.path)
us.shape48 <- readOGR(dsn = path.expand(shp.path), layer = shp.layer, verbose = FALSE)

shp.data <- shape.H(system.path)
names(shp.data)
}
\author{
Erica M. Porter, Matthew J. Keefe, Christopher T. Franck, and Marco A.R. Ferreira
}
