% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_functions.R
\name{extrapolateEstimate}
\alias{extrapolateEstimate}
\title{Extrapolate Estimate}
\usage{
extrapolateEstimate(A.t1, year.t1, nYears, ARD = NA, PRD = NA, ARC = NA)
}
\arguments{
\item{A.t1}{Area at time t1}

\item{year.t1}{Year of time t1}

\item{nYears}{Number of years since t1 for prediction. Use negative
values for backcasting}

\item{ARD}{Absolute rate of decline}

\item{PRD}{Proportional rate of decline}

\item{ARC}{Annual rate of change}
}
\value{
A dataframe with the forecast year, and a combination of:
\itemize{
 \item Values as extrapolated with absolute rate of decline (ARD)
 \item Values as extrapolated with proportional rate of decline (PRD)
 \item Values as extrapolated with annual rate of change (ARC)
 }
}
\description{
\code{extrapolateEstimate} uses rates of decline from getDeclineStats
to extrapolate estimates to a given time
}
\examples{
a.r1 <- 23.55
a.r2 <- 15.79
decline.stats <- getDeclineStats(a.r1, a.r2, year.t1 = 1990, year.t2 = 2012,
                                 methods = 'PRD')
a.2040.PRD <- extrapolateEstimate(a.r1, a.r2, year.t1 = 1990, nYears = 50,
                                  PRD = decline.stats$PRD)
}
\references{
Bland, L.M., Keith, D.A., Miller, R.M., Murray, N.J. and
  Rodriguez, J.P. (eds.) 2016. Guidelines for the application of IUCN Red
  List of Ecosystems Categories and Criteria, Version 1.0. Gland,
  Switzerland: IUCN. ix + 94pp. Available at the following web site:
  \url{https://iucnrle.org/}
}
\seealso{
Other change_functions: \code{\link{futureAreaEstimate}},
  \code{\link{sequentialExtrapolate}}
}
\author{
Nicholas Murray \email{murr.nick@gmail.com}, Calvin Lee
  \email{calvinkflee@gmail.com}
}
