% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_mcmc.R
\name{redist.flip.anneal}
\alias{redist.flip.anneal}
\title{(Deprecated) Flip MCMC Redistricting Simulator using Simulated Annealing}
\usage{
redist.flip.anneal(
  adj,
  total_pop,
  ndists = NULL,
  init_plan = NULL,
  constraints = redist_constr(),
  num_hot_steps = 40000,
  num_annealing_steps = 60000,
  num_cold_steps = 20000,
  eprob = 0.05,
  lambda = 0,
  pop_tol = NULL,
  rngseed = NULL,
  maxiterrsg = 5000,
  adapt_lambda = FALSE,
  adapt_eprob = FALSE,
  exact_mh = FALSE,
  savename = NULL,
  verbose = TRUE
)
}
\arguments{
\item{adj}{adjacency matrix, list, or object of class
"SpatialPolygonsDataFrame."}

\item{total_pop}{A vector containing the populations of each geographic
unit}

\item{ndists}{The number of congressional districts. The default is
\code{NULL}.}

\item{init_plan}{A vector containing the congressional district labels
of each geographic unit. If not provided, random and contiguous congressional
district assignments will be generated using \code{redist_smc}. To use the old
behavior of generating with \code{redist.rsg}, provide init_plan = 'rsg'.}

\item{constraints}{A `redist_constr` list of constraints}

\item{num_hot_steps}{The number of steps to run the simulator at beta = 0.
Default is 40000.}

\item{num_annealing_steps}{The number of steps to run the simulator with
linearly changing beta schedule. Default is 60000}

\item{num_cold_steps}{The number of steps to run the simulator at beta = 1.
Default is 20000.}

\item{eprob}{The probability of keeping an edge connected. The
default is \code{0.05}.}

\item{lambda}{The parameter determining the number of swaps to attempt
each iteration of the algorithm. The number of swaps each iteration is
equal to Pois(\code{lambda}) + 1. The default is \code{0}.}

\item{pop_tol}{The strength of the hard population
constraint. \code{pop_tol} = 0.05 means that any proposed swap that
brings a district more than 5\% away from population parity will be
rejected. The default is \code{NULL}.}

\item{rngseed}{Allows the user to set the seed for the
simulations. Default is \code{NULL}.}

\item{maxiterrsg}{Maximum number of iterations for random seed-and-grow
algorithm to generate starting values. Default is 5000.}

\item{adapt_lambda}{Whether to adaptively tune the lambda parameter so that the Metropolis-Hastings
acceptance probability falls between 20\% and 40\%. Default is FALSE.}

\item{adapt_eprob}{Whether to adaptively tune the edgecut probability parameter so that the
Metropolis-Hastings acceptance probability falls between 20\% and 40\%. Default is
FALSE.}

\item{exact_mh}{Whether to use the approximate (0) or exact (1)
Metropolis-Hastings ratio calculation for accept-reject rule. Default is FALSE.}

\item{savename}{Filename to save simulations. Default is \code{NULL}.}

\item{verbose}{Whether to print initialization statement.
Default is \code{TRUE}.}
}
\value{
list of class redist
}
\description{
\code{redist.flip.anneal} simulates congressional redistricting plans
using Markov chain Monte Carlo methods coupled with simulated annealing.
}
\concept{simulate}
