% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick_a_plan.R
\name{pick_a_plan}
\alias{pick_a_plan}
\title{Pick One Plan from Many Plans}
\usage{
pick_a_plan(
  plans,
  map,
  counties = NULL,
  comp = NULL,
  maximize_comp = TRUE,
  cut_point = 0.3
)
}
\arguments{
\item{plans}{a redist_plans object}

\item{map}{a redist_map object}

\item{counties}{A column in map with county names. Defaults to NULL and will
assume each row in map is its own county if left NULL}

\item{comp}{A column in plans with compactness. Defaults to NULL and will
calculate FracKept if left NULL}

\item{maximize_comp}{Should comp be maximized? Defaults to TRUE.}

\item{cut_point}{portion of plans to keep at each step}
}
\value{
An integer vector with a single plan
}
\description{
Pick One Plan from Many Plans
}
\examples{
data(iowa)
map <- redist_map(iowa, existing_plan = cd_2010, pop_tol = 0.01, total_pop = pop)
sims <- redist_smc(map, 100)
pick_a_plan(sims, map)

}
