% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importRecords.R
\name{importRecords}
\alias{importRecords}
\alias{importRecords.redcapApiConnection}
\title{Import Records to a Project}
\usage{
importRecords(
  rcon,
  data,
  overwriteBehavior = c("normal", "overwrite"),
  returnContent = c("count", "ids", "nothing", "auto_ids"),
  returnData = FALSE,
  logfile = "",
  ...
)

\method{importRecords}{redcapApiConnection}(
  rcon,
  data,
  overwriteBehavior = c("normal", "overwrite"),
  returnContent = c("count", "ids", "nothing", "auto_ids"),
  returnData = FALSE,
  logfile = "",
  force_auto_number = FALSE,
  ...,
  batch.size = -1,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{data}{A \code{data.frame} to be imported to the project.}

\item{overwriteBehavior}{\code{character(1)}. One of \code{c("normal", "overwrite")}.
\code{"normal"} prevents blank fields from overwriting populated fields.
\code{"overwrite"} causes blanks to overwrite data in the database.}

\item{returnContent}{\code{character(1)}.
One of \code{c("count", "ids", "nothing", "auto_ids")}.
'count' returns the number of records imported;
'ids' returns the record ids that are imported;
'nothing' returns no message;
'auto_ids' returns a list of pairs of all record IDs that were imported.
If used when \code{force_auto_number = FALSE}, the value will be changed to \code{'ids'}.}

\item{returnData}{\code{logical(1)}. When \code{TRUE}, prevents the REDCap
import and instead returns the data frame that would have been given
for import. This is sometimes helpful if the API import fails without
providing an informative message. The data frame can be written to a csv
and uploaded using the interactive tools to troubleshoot the
problem.}

\item{logfile}{\code{character(1)}. An optional filepath (preferably .txt)
in which to print the log of errors and warnings about the data.
When \code{""}, the log is printed to the console.}

\item{...}{Arguments to pass to other methods}

\item{force_auto_number}{\code{logical(1)}. If record auto-numbering has been
enabled in the project, it may be desirable to import records where each
record's record name is automatically determined by REDCap (just as it
does in the user interface). When \code{TRUE}, the
record names provided in the request will not be used (although they
are still required in order to associate multiple rows of data to an
individual record in the request); instead those records in the
request will receive new record names during the import process.
It is recommended that the user use \code{returnContent = "auto_ids"}
when \code{force_auto_number = TRUE}}

\item{batch.size}{\code{integerish(1)}.  Specifies the number of subjects to be included
in each batch of a batched export or import.  Non-positive numbers
export/import the entire operation in a single batch.
Batching may be beneficial to prevent tying up smaller servers.
See Details.}

\item{error_handling}{\code{character(1)}. One of \code{c("error", "null")}.
An option for how to handle errors returned by the API.
see \code{\link[=redcapError]{redcapError()}}.}

\item{config}{A named \code{list}. Additional configuration parameters to pass to
\code{\link[httr:POST]{httr::POST()}}. These are appended to any parameters in
\code{rcon$config}.}

\item{api_param}{A named \code{list}. Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\value{
\code{importRecords}, when \code{returnData = FALSE}, returns the content from the
API response designated by the \code{returnContent} argument.

\code{importRecords}, when \code{returnData = TRUE}, returns the
data frame that was internally prepared for import. This data frame has
values transformed from R objects to character values the API will
accept.
}
\description{
These methods enable the user to import new records or update
existing records to a project.
}
\details{
\code{importRecords} prevents the most common import errors by testing the
data before attempting the import.  Namely
\enumerate{
\item Check that all variables in \code{data} exist in the REDCap data dictionary.
\item Check that the record id variable exists
\item Force the record id variable to the first position in the data frame (with a warning)
\item Remove calculated fields (with a warning)
\item Verify that REDCap date fields are represented in the data frame as either \code{character}, \code{POSIXct}, or \code{Date} class objects.
\item Determine if values are within their specified validation limits.
}

See the documentation for \code{\link[=validateImport]{validateImport()}} for detailed
explanations of the validation.

A 'batched' import is one where the export is performed over a series of
API calls rather than one large call.  For large projects on small servers,
this may prevent a single user from tying up the server and forcing others
to wait on a larger job.
\subsection{BioPortal Fields}{

Text fields that are validation enabled using the BioPortal Ontology service
may be imported by providing the coded value. Importing the coded value
does not, however, guarantee that the labeled value will be immediately
available. Labels for BioPortal values are cached on the REDCap server
in a process that occurs when viewing data in the user interface. Thus,
if the label has not be previously cached on the server, the code will be
used to represent both the code and the label.
}
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())

# Import records
NewData <- data.frame(record_id = c(1, 2, 3), 
                      age = c(27, 43, 32), 
                      date_of_visit = rep(Sys.Date(), 3))
importRecords(rcon, 
              data = NewData)
              
              
# Import records and save validation info to a file
NewData <- data.frame(record_id = c(1, 2, 3), 
                      age = c(27, 43, 32), 
                      date_of_visit = rep(Sys.Date(), 3))
importRecords(rcon, 
              data = NewData, 
              logfile = "import-validation-notes.txt")      

} 

}
\seealso{
\code{\link[=exportRecords]{exportRecords()}}, \cr
\code{\link[=deleteRecords]{deleteRecords()}}, \cr
\code{\link[=exportRecordsTyped]{exportRecordsTyped()}}
}
