% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportFilesMultiple.R
\name{exportFilesMultiple}
\alias{exportFilesMultiple}
\alias{exportFilesMultiple.redcapApiConnection}
\title{Export Multiple Files From a Project}
\usage{
exportFilesMultiple(
  rcon,
  record,
  field,
  event = NULL,
  dir,
  file_prefix = TRUE,
  ...
)

\method{exportFilesMultiple}{redcapApiConnection}(
  rcon,
  record,
  field,
  event = NULL,
  dir,
  file_prefix = TRUE,
  repeat_instance = NULL,
  ...,
  quiet = TRUE,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{record}{\code{character} or \code{integerish}. The record ID in
which the desired file is stored.}

\item{field}{\code{character}. The field name in which the file is stored.}

\item{event}{\code{character} or \code{NULL}. The event name for the file.
This applies only to longitudinal projects.  If the event is not
supplied for a longitudinal project, the API will return an error message}

\item{dir}{\code{character(1)}. A directory/folder to which the file
will be saved. By default, the working directory is used.}

\item{file_prefix}{\code{logical(1)}.  Determines if a prefix is appended
to the file name.  The prefix takes the form \verb{[record_id]-[event_name]-[file_name]}.
The file name is always the same name of the file as it exists in REDCap.}

\item{...}{Arguments to pass to other methods}

\item{repeat_instance}{\code{integerish} or \code{NULL}. The repeat instance number of
the repeating event or the repeating instrument. When available in your
instance of REDCap, and passed as \code{NULL}, the API will assume a value of 1.}

\item{quiet}{\code{logical(1)}. When \code{TRUE}, any errors encountered while
exporting files will be converted to messages.}

\item{error_handling}{\code{character(1)}. One of \code{c("error", "null")}.
An option for how to handle errors returned by the API.
see \code{\link[=redcapError]{redcapError()}}.}

\item{config}{A named \code{list}. Additional configuration parameters to pass to
\code{\link[httr:POST]{httr::POST()}}. These are appended to any parameters in
\code{rcon$config}.}

\item{api_param}{A named \code{list}. Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\value{
Invisibly returns a \code{data.frame} with the following columns:\tabular{ll}{
   Column \tab Description \cr
   \code{record} \tab The record ID \cr
   \code{field} \tab The name of the field in which the file is stored. \cr
   \code{event} \tab The name of the event associated with the file. \cr
   \code{repeat_instance} \tab For repeat instances, the instance associated with the file. \cr
   \code{is_exported} \tab \code{logical} indicating if the file was successfully exported. \cr
   \code{saved_to} \tab The file path to which the file was saved. \cr
   \code{error} \tab If an error was encountered, the text of the error. \cr
}
}
\description{
This method enables the user to export multiple files from
a REDCap project with a single call. The REDCap API only allows for one
file to be exported per call, and the \code{\link[=exportFiles]{exportFiles()}} methods are written
to mirror that limitation. This extension allows the user to pass
vectors of arguments for records, fields, events, or repeat instances.
Files that can be matched to any combination of these values will
be exported.
}
\details{
\code{exportFilesMultiple} will construct all combinations of
the \code{record}, \code{field}, \code{event}, and \code{repeat_instance} arguments and
attempt to export the file associated with each combination. Should any
of these combinations produce an error (for example, if a record does not
have a third repeat instance), the error is captured and returned
with the output.
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
save_to_dir <- tempdir() 

# Export files for multiple records
# Results are returned invisibly - saving to an object is
#   helpful to be able to view the results

Export <- 
  exportFilesMultiple(rcon, 
                      record = 1:4, 
                      field = "file_upload_field", 
                      event = "event_1_arm_1", 
                      dir = save_to_dir)
Export 
                    
# Export files for multiple instances

Export <- 
  exportFilesMultiple(rcon, 
                      record = 1, 
                      field = "file_upload_field", 
                      event = "event_1_arm_1", 
                      repeat_instance = 1:4, 
                      dir = save_to_dir)
Export
                    
# Export files for multiple records, fields, events, and instances

Export <- 
  exportFilesMultiple(rcon, 
                      record = 1:10, 
                      field = c("registration", "waiver"), 
                      events = c("event_1_arm_1", "event_2_arm_1"), 
                      repeat_instance = 1:3, 
                      dir = save_to_dir)
Export
}


}
\seealso{
\code{\link[=exportFiles]{exportFiles()}}
}
