% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingSummary.R
\name{missingSummary}
\alias{missingSummary}
\alias{missingSummary_offline}
\alias{missingSummary.redcapApiConnection}
\title{Report of Missing Values}
\usage{
missingSummary(
  rcon,
  excludeMissingForms = TRUE,
  ...,
  fixed_fields = REDCAP_SYSTEM_FIELDS
)

\method{missingSummary}{redcapApiConnection}(
  rcon,
  excludeMissingForms = TRUE,
  ...,
  fixed_fields = REDCAP_SYSTEM_FIELDS,
  exportRecordsArgs = list(),
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)

missingSummary_offline(
  records,
  meta_data,
  excludeMissingForms = TRUE,
  fixed_fields = REDCAP_SYSTEM_FIELDS
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{excludeMissingForms}{\code{logical(1)} If all of the fields in a form are missing, would 
you like to assume that they are purposefully missing?  For instance, if
a patient did not experience an adverse event, the adverse event form would
contain no data and you would not want it in this report.}

\item{...}{Additional arguments to pass to other methods.  Currently ignored.}

\item{fixed_fields}{\code{character} A vector of field names that will be used as 
the identifying fields in the output summary. This always includes the record
identifier (ie, the first field in the data dictionary). By default it 
also includes any fields identified in \code{REDCAP_SYSTEM_FIELDS}, which
are fields that REDCap adds to exports to identify arms, events, etc. 
see \code{\link{constants}}.}

\item{exportRecordsArgs}{named \code{list} with arguments to pass to \code{exportRecords}. 
This allows for testing specific forms, events, and/or records. Internally, any 
setting you make for \code{factors, labels, dates, survey}, or \code{dag} 
arguments will be ignored.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}

\item{records}{\code{character(1)} A filename pointing to the raw records download from REDCap}

\item{meta_data}{\code{character(1)} A filename pointing to the data dictionary download from REDCap}
}
\description{
Returns a data frame of subject events with missing values.
}
\details{
The intention of this function is to generate a list of subject
  events that are missing and could potentially be values that should have
  been entered.
  
  The branching logic from the data dictionary is parsed and translated into
  and R expression.  When a field with branching logic passes the logical
  statement, it is evaluated with \code{is.na}, otherwise, it is set to 
  \code{FALSE} (non-missing, because there was never an opportunity to 
  provide a value).
  
  Optionally, forms that are entirely missing can be determined to be 
  non-missing.  This is applicable when, for instance, a patient did not 
  have an adverse event.  In this case, a form dedicated to adverse events 
  would contain meaningless missing values and could be excluded from the 
  report.
}
\author{
Benjamin Nutter
}
