% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{session_length}
\alias{session_length}
\title{Counts the length of each session within a set}
\usage{
session_length(sessions, padding_value = 430L,
  preserve_single_events = FALSE, strip_last = FALSE)
}
\arguments{
\item{sessions}{a list of sessions, extracted via \code{\link{reconstruct_sessions}}}

\item{padding_value}{the time to use for padding the session length, to accomodate the time spent idling
on the last event in the session or (in the case of one-event sessions) the only event in the session.}

\item{preserve_single_events}{whether to attempt to calculate values for single page sessions (TRUE), or ignore
them and instead return the value -1 (FALSE). Set to FALSE by default.}

\item{strip_last}{whether to strip the last event in a session (TRUE) or include it and attempt
to calculate the time spent on it via \code{padding_value}. Set to FALSE by default.}
}
\value{
a vector of session length counts, in seconds, with -1 for sessions containing a single event
(or not. See the \code{single_page_sessions} parameter).
}
\description{
\code{session_length} takes a list of sessions (generated via \code{\link{reconstruct_sessions}})
and calculates the approximate length (in seconds) of each session. See the "session metrics"
vignette for more details.

\code{session_length} does not compute the length of sessions that consist of a single event,
unless \code{single_page_sessions} is set to true. Instead, it returns the numeric value -1
for those sessions.
}
\examples{
\dontrun{
#With a sessionised dataset (see ?reconstruct_sessions for an example)
lengths <- session_length(sessions = sessions, padding_value = 200, preserve_single_events = TRUE)
}
}
\seealso{
\code{\link{reconstruct_sessions}}, for generating sessions, \code{\link{session_events}} for
simply counting the number of events in each session, and \code{\link{bounce_rate}} for calculating
the bounce rate of the session set overall.
}

