% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitByColor.R
\name{splitByColor}
\alias{splitByColor}
\title{Split color clusters in a recolorize object into layers}
\usage{
splitByColor(recolorize_obj, layers = "all", plot_method = "overlay")
}
\arguments{
\item{recolorize_obj}{A recolorize object from \code{\link{recolorize}},
\code{\link{recluster}}, or \code{\link{imposeColors}}.}

\item{layers}{Either \code{"all"} or a numeric vector of which color centers to
return.}

\item{plot_method}{Plotting method for plotting the color layers. Options
are\code{"overlay"}, \code{"binary"}, \code{"colormask"}, or \code{"none"}.}
}
\value{
A list of binary matrices (1/white = color presence, 0/black = color
absence), one per color center.
}
\description{
Separates color clusters from a \code{\link{recolorize}},
\code{\link{recluster}}, or \code{\link{imposeColors}} object
into binary masks.
}
\examples{
# get original fit
corbetti <- system.file("extdata/corbetti.png", package = "recolorize")
recolored_corbetti <- recolorize::recolorize(corbetti, plotting = TRUE)

# to reset graphical parameters:
current_par <- graphics::par(no.readonly = TRUE)

# make a layout
layout(matrix(c(1, 1:9), nrow = 2))
par(mar = c(0, 0, 2, 0))
# plot original
plotImageArray(recolored_corbetti$original_img)

# plot layers
corbetti_layers <- splitByColor(recolored_corbetti, plot_method = "over")

# plot binary maps
plotImageArray(recolored_corbetti$original_img)
for (i in 1:length(corbetti_layers)) {
  plotImageArray(corbetti_layers[[i]])
}

graphics::par(current_par)
}
