% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{step_date}
\alias{step_date}
\title{Date Feature Generator}
\usage{
step_date(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  features = c("dow", "month", "year"),
  abbr = TRUE,
  label = TRUE,
  ordinal = FALSE,
  locale = clock::clock_locale()$labels,
  columns = NULL,
  keep_original_cols = TRUE,
  skip = FALSE,
  id = rand_id("date")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. The selected variables should have class \code{Date} or
\code{POSIXct}. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from
the original variables will be used as \emph{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{features}{A character string that includes at least one
of the following values: \code{month}, \code{dow} (day of week),
\code{doy} (day of year), \code{week}, \code{month},
\code{decimal} (decimal date, e.g. 2002.197), \code{quarter},
\code{semester}, \code{year}.}

\item{abbr}{A logical. Only available for features \code{month}
or \code{dow}. \code{FALSE} will display the day of the week as
an ordered factor of character strings, such as "Sunday".
\code{TRUE} will display an abbreviated version of the label,
such as "Sun". \code{abbr} is disregarded if \code{label = FALSE}.}

\item{label}{A logical. Only available for features
\code{month} or \code{dow}. \code{TRUE} will display the day of
the week as an ordered factor of character strings, such as
"Sunday." \code{FALSE} will display the day of the week as a
number.}

\item{ordinal}{A logical: should factors be ordered? Only
available for features \code{month} or \code{dow}.}

\item{locale}{Locale to be used for \code{month} and \code{dow}, see \link{locales}.
On Linux systems you can use \code{system("locale -a")} to list all the
installed locales. Can be a locales string, or a \code{\link[clock:clock_labels]{clock::clock_labels()}}
object. Defaults to \code{clock::clock_locale()$labels}.}

\item{columns}{A character string of the selected variable names. This field
is a placeholder and will be populated once \code{\link[=prep]{prep()}} is used.}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{TRUE}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_date()} creates a \emph{specification} of a recipe step that will convert
date data into one or more factor or numeric variables.
}
\details{
Unlike some other steps, \code{step_date} does \emph{not}
remove the original date variables by default. Set \code{keep_original_cols}
to \code{FALSE} to remove them.

See \code{\link[=step_time]{step_time()}} if you want to calculate features that are smaller than
days.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns
\code{terms} (the selectors or variables selected), \code{value} (the feature
names), and \code{ordinal} (a logical) is returned.
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
library(lubridate)

examples <- data.frame(
  Dan = ymd("2002-03-04") + days(1:10),
  Stefan = ymd("2006-01-13") + days(1:10)
)
date_rec <- recipe(~ Dan + Stefan, examples) \%>\%
  step_date(all_predictors())

tidy(date_rec, number = 1)

date_rec <- prep(date_rec, training = examples)

date_values <- bake(date_rec, new_data = examples)
date_values

tidy(date_rec, number = 1)
}
\seealso{
Other dummy variable and encoding steps: 
\code{\link{step_bin2factor}()},
\code{\link{step_count}()},
\code{\link{step_dummy_extract}()},
\code{\link{step_dummy_multi_choice}()},
\code{\link{step_dummy}()},
\code{\link{step_factor2string}()},
\code{\link{step_holiday}()},
\code{\link{step_indicate_na}()},
\code{\link{step_integer}()},
\code{\link{step_novel}()},
\code{\link{step_num2factor}()},
\code{\link{step_ordinalscore}()},
\code{\link{step_other}()},
\code{\link{step_regex}()},
\code{\link{step_relevel}()},
\code{\link{step_string2factor}()},
\code{\link{step_time}()},
\code{\link{step_unknown}()},
\code{\link{step_unorder}()}
}
\concept{dummy variable and encoding steps}
