% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-groups.R
\name{ClassGroups}
\alias{ClassGroups}
\alias{alnum}
\alias{alpha}
\alias{any_char}
\alias{ascii_alnum}
\alias{ascii_alpha}
\alias{ascii_digit}
\alias{ascii_lower}
\alias{ascii_upper}
\alias{blank}
\alias{char_range}
\alias{cntrl}
\alias{dgt}
\alias{digit}
\alias{graph}
\alias{hex_digit}
\alias{lower}
\alias{not_dgt}
\alias{not_spc}
\alias{not_wrd}
\alias{printable}
\alias{punct}
\alias{space}
\alias{spc}
\alias{upper}
\alias{wrd}
\title{Character classes}
\usage{
alnum(lo, hi, char_class = TRUE)

alpha(lo, hi, char_class = TRUE)

blank(lo, hi, char_class = TRUE)

cntrl(lo, hi, char_class = TRUE)

digit(lo, hi, char_class = TRUE)

graph(lo, hi, char_class = TRUE)

lower(lo, hi, char_class = TRUE)

printable(lo, hi, char_class = TRUE)

punct(lo, hi, char_class = TRUE)

space(lo, hi, char_class = TRUE)

upper(lo, hi, char_class = TRUE)

hex_digit(lo, hi, char_class = TRUE)

any_char(lo, hi)

dgt(lo, hi, char_class = TRUE)

wrd(lo, hi, char_class = TRUE)

spc(lo, hi, char_class = TRUE)

not_dgt(lo, hi, char_class = TRUE)

not_wrd(lo, hi, char_class = TRUE)

not_spc(lo, hi, char_class = TRUE)

ascii_digit(lo, hi, char_class = TRUE)

ascii_lower(lo, hi, char_class = TRUE)

ascii_upper(lo, hi, char_class = TRUE)

ascii_alpha(lo, hi, char_class = TRUE)

ascii_alnum(lo, hi, char_class = TRUE)

char_range(lo, hi, char_class = lo < hi)
}
\arguments{
\item{lo}{A non-negative integer. Minimum number of repeats, when grouped.}

\item{hi}{positive integer. Maximum number of repeats, when grouped.}

\item{char_class}{A logical value. Should \code{x} be wrapped in a character
class?  If \code{NA}, the function guesses whether that's a good idea.}
}
\value{
A character vector representing part or all of a regular expression.
}
\description{
Match character classes.
}
\note{
R has many built-in locale-dependent character classes, like
\code{[:alnum:]} (representing alphanumeric characters, that is lower or
upper case letters or numbers). Some of these behave in unexpected ways
when using the ICU engine (that is, when using \code{stringi} or
\code{stringr}). See the punctuation example. For these engines, using
Unicode properties (\code{\link[rebus.unicode]{UnicodeProperty}}) may give
you a more reliable match.
There are also some generic character classes like \code{\\w} (representing
lower or upper case letters or numbers or underscores).
Finally, there are ASCII-only ways of specifying letters like \code{a-zA-Z}.
Which version you want depends upon how you want to deal with international
characters, and the vagaries of the underlying regular expression engine.
I suggest reading the \code{\link[base]{regex}} help page and doing lots of
testing.
}
\examples{
# R character classes
alnum()
alpha()
blank()
cntrl()
digit()
graph()
lower()
printable()
punct()
space()
upper()
hex_digit()

# Generic classes
any_char()
dgt()
wrd()
spc()

# Generic negated classes
not_dgt()
not_wrd()
not_spc()

# Non-locale-specific classes
ascii_digit()
ascii_lower()
ascii_upper()

# Don't provide a class wrapper
digit(char_class = FALSE) # same as DIGIT

# Match repeated values
digit(3)
digit(3, 5)
digit(0)
digit(1)
digit(0, 1)

# Ranges of characters
char_range(0, 7) # octal number

# Usage
(rx <- digit(3))
stringi::stri_detect_regex(c("123", "one23"), rx)

# Some classes behave differently under different engines
# In particular PRCE and Perl recognise all these characters
# as punctuation but ICU does not
p <- c(
  "!", "@", "#", "$", "\%", "^", "&", "*", "(", ")", "[", "]", "{", "}", ";",
  ":", "'", '"', ",", "<", ">", ".", "/", "?", "\\\\", "|", "`", "~"
)
icu_matched <- stringi::stri_detect_regex(p, punct())
p[icu_matched]
p[!icu_matched]
pcre_matched <- grepl(punct(), p)
p[pcre_matched]
p[!pcre_matched]
}
\references{
\url{http://www.regular-expressions.info/shorthand.html} and
\url{http://www.rexegg.com/regex-quickstart.html#posix}
}
\seealso{
\code{\link[base]{regex}}, \code{\link[rebus.unicode]{Unicode}}
}

