library(rearrr)
context("center_*()")


test_that("fuzz testing center_max()", {
  xpectr::set_test_seed(42)

  # Create a data frame
  df <- data.frame(
    "index" = 1:9,
    "A" = sample(1:9),
    "B" = runif(9),
    "C" = LETTERS[1:9],
    stringsAsFactors = FALSE
  )

  # Generate expectations
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = center_max,
  #   args_values = list(
  #     "data" = list(df, head(df, 8), c(1,2,3,4,5,6,7), c(1,2,3,4),
  #                   factor(c(1,2,3,4,5,6,7,1,2,3)), list(1,2,3), NA, 1),
  #     "col" = list(NULL, "A", "B", "C"),
  #     "shuffle_sides" = list(FALSE, TRUE)
  #   ),
  #   extra_combinations = list(
  #     list("data" = c(1,2,3,4), "col" = "A")
  #   ),
  #   indentation = 2
  # )


  ## Testing 'center_max'                                                     ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing center_max(data = df, col = NULL, shuffle_si...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- center_max(data = df, col = NULL, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["index"]],
    c(1, 3, 5, 7, 9, 8, 6, 4, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["A"]],
    c(9, 3, 4, 6, 2, 1, 7, 5, 8),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["B"]],
    c(0.70506, 0.71911, 0.25543, 0.94001, 0.11749, 0.97823, 0.46229,
      0.93467, 0.45774),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["C"]],
    c("A", "C", "E", "G", "I", "H", "F", "D", "B"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("index", "A", "B", "C"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "integer", "numeric", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "integer", "double", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(9L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing center_max(data = head(df, 8), col = NULL, s...
  # Changed from baseline: data = head(df, 8)
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- center_max(data = head(df, 8), col = NULL, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_19370),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19370[["index"]],
    c(1, 3, 5, 7, 8, 6, 4, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["A"]],
    c(9, 3, 4, 6, 1, 7, 5, 8),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["B"]],
    c(0.70506, 0.71911, 0.25543, 0.94001, 0.97823, 0.46229, 0.93467,
      0.45774),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["C"]],
    c("A", "C", "E", "G", "H", "F", "D", "B"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19370),
    c("index", "A", "B", "C"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19370),
    c("integer", "integer", "numeric", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19370),
    c("integer", "integer", "double", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19370),
    c(8L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19370)),
    character(0),
    fixed = TRUE)

  # Testing center_max(data = c(1, 2, 3, 4, 5, 6, 7), co...
  # Changed from baseline: data = c(1, 2, 3, 4, ...
  xpectr::set_test_seed(42)
  # Assigning output
  output_12861 <- center_max(data = c(1, 2, 3, 4, 5, 6, 7), col = NULL, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_12861),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12861,
    type = "double")
  # Testing values
  expect_equal(
    output_12861,
    c(1, 3, 5, 7, 6, 4, 2),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_12861),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12861),
    7L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12861)),
    7L)

  # Testing center_max(data = c(1, 2, 3, 4), col = NULL,...
  # Changed from baseline: data = c(1, 2, 3, 4)
  xpectr::set_test_seed(42)
  # Assigning output
  output_18304 <- center_max(data = c(1, 2, 3, 4), col = NULL, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_18304),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_18304,
    type = "double")
  # Testing values
  expect_equal(
    output_18304,
    c(1, 3, 4, 2),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_18304),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_18304),
    4L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_18304)),
    4L)

  # Testing center_max(data = factor(c(1, 2, 3, 4, 5, 6,...
  # Changed from baseline: data = factor(c(1, 2,...
  xpectr::set_test_seed(42)
  # Assigning output
  output_16417 <- center_max(data = factor(c(1, 2, 3, 4, 5, 6, 7, 1, 2, 3)), col = NULL, shuffle_sides = FALSE)
  # Testing is factor
  expect_true(
    is.factor(output_16417))
  # Testing values
  expect_equal(
    as.character(output_16417),
    c("1", "2", "3", "4", "6", "7", "5", "3", "2", "1"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_16417),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_16417),
    10L)
  # Testing number of levels
  expect_equal(
    nlevels(output_16417),
    7L)
  # Testing levels
  expect_equal(
    levels(output_16417),
    c("1", "2", "3", "4", "5", "6", "7"),
    fixed = TRUE)

  # Testing center_max(data = list(1, 2, 3), col = NULL,...
  # Changed from baseline: data = list(1, 2, 3)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(center_max(data = list(1, 2, 3), col = NULL, shuffle_sides = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, it cannot be a list."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing center_max(data = NA, col = NULL, shuffle_si...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(center_max(data = NA, col = NULL, shuffle_sides = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error']]),
    xpectr::strip(ifelse(
      is_checkmate_v2_1(),
      "Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'logical'\n * checkmate::check_vector(data): Contains missing values (element 1)\n * checkmate::check_factor(data): Must be of type 'factor', not 'logical'",
      "Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'logical'\n * checkmate::check_vector(data): Contains missing values (element 1)\n * checkmate::check_factor(data): Contains missing values (element 1)")),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing center_max(data = 1, col = NULL, shuffle_sid...
  # Changed from baseline: data = 1
  xpectr::set_test_seed(42)
  # Assigning output
  output_11346 <- center_max(data = 1, col = NULL, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_11346),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_11346,
    type = "double")
  # Testing values
  expect_equal(
    output_11346,
    1,
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_11346),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_11346),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_11346)),
    1L)

  # Testing center_max(data = NULL, col = NULL, shuffle_...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(center_max(data = NULL, col = NULL, shuffle_sides = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'NULL'\n * checkmate::check_vector(data): Must be of type 'vector', not 'NULL'\n * checkmate::check_factor(data): Must be of type 'factor', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing center_max(data = c(1, 2, 3, 4), col = "A", ...
  # Changed from baseline: data, col
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(center_max(data = c(1, 2, 3, 4), col = "A", shuffle_sides = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing center_max(data = df, col = "C", shuffle_sid...
  # Changed from baseline: col = "C"
  xpectr::set_test_seed(42)
  # Assigning output
  output_14577 <- center_max(data = df, col = "C", shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_14577),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14577[["index"]],
    c(1, 3, 5, 7, 9, 8, 6, 4, 2),
    tolerance = 1e-4)
  expect_equal(
    output_14577[["A"]],
    c(9, 3, 4, 6, 2, 1, 7, 5, 8),
    tolerance = 1e-4)
  expect_equal(
    output_14577[["B"]],
    c(0.70506, 0.71911, 0.25543, 0.94001, 0.11749, 0.97823, 0.46229,
      0.93467, 0.45774),
    tolerance = 1e-4)
  expect_equal(
    output_14577[["C"]],
    c("A", "C", "E", "G", "I", "H", "F", "D", "B"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_14577),
    c("index", "A", "B", "C"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14577),
    c("integer", "integer", "numeric", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14577),
    c("integer", "integer", "double", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14577),
    c(9L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14577)),
    character(0),
    fixed = TRUE)

  # Testing center_max(data = df, col = "A", shuffle_sid...
  # Changed from baseline: col = "A"
  xpectr::set_test_seed(42)
  # Assigning output
  output_17191 <- center_max(data = df, col = "A", shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_17191),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17191[["index"]],
    c(8, 3, 4, 6, 1, 2, 7, 5, 9),
    tolerance = 1e-4)
  expect_equal(
    output_17191[["A"]],
    c(1, 3, 5, 7, 9, 8, 6, 4, 2),
    tolerance = 1e-4)
  expect_equal(
    output_17191[["B"]],
    c(0.97823, 0.71911, 0.93467, 0.46229, 0.70506, 0.45774, 0.94001,
      0.25543, 0.11749),
    tolerance = 1e-4)
  expect_equal(
    output_17191[["C"]],
    c("H", "C", "D", "F", "A", "B", "G", "E", "I"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_17191),
    c("index", "A", "B", "C"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17191),
    c("integer", "integer", "numeric", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17191),
    c("integer", "integer", "double", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17191),
    c(9L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17191)),
    character(0),
    fixed = TRUE)

  # Testing center_max(data = df, col = "B", shuffle_sid...
  # Changed from baseline: col = "B"
  xpectr::set_test_seed(42)
  # Assigning output
  output_19346 <- center_max(data = df, col = "B", shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_19346),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19346[["index"]],
    c(9, 2, 1, 4, 8, 7, 3, 6, 5),
    tolerance = 1e-4)
  expect_equal(
    output_19346[["A"]],
    c(2, 8, 9, 5, 1, 6, 3, 7, 4),
    tolerance = 1e-4)
  expect_equal(
    output_19346[["B"]],
    c(0.11749, 0.45774, 0.70506, 0.93467, 0.97823, 0.94001, 0.71911,
      0.46229, 0.25543),
    tolerance = 1e-4)
  expect_equal(
    output_19346[["C"]],
    c("I", "B", "A", "D", "H", "G", "C", "F", "E"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19346),
    c("index", "A", "B", "C"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19346),
    c("integer", "integer", "numeric", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19346),
    c("integer", "integer", "double", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19346),
    c(9L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19346)),
    character(0),
    fixed = TRUE)

  # Testing center_max(data = df, col = NULL, shuffle_si...
  # Changed from baseline: shuffle_sides = TRUE
  xpectr::set_test_seed(42)
  # Assigning output
  output_12554 <- center_max(data = df, col = NULL, shuffle_sides = TRUE)
  # Testing class
  expect_equal(
    class(output_12554),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_12554[["index"]],
    c(2, 4, 5, 8, 9, 7, 6, 3, 1),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["A"]],
    c(8, 5, 4, 1, 2, 6, 7, 3, 9),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["B"]],
    c(0.45774, 0.93467, 0.25543, 0.97823, 0.11749, 0.94001, 0.46229,
      0.71911, 0.70506),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["C"]],
    c("B", "D", "E", "H", "I", "G", "F", "C", "A"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_12554),
    c("index", "A", "B", "C"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_12554),
    c("integer", "integer", "numeric", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_12554),
    c("integer", "integer", "double", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12554),
    c(9L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_12554)),
    character(0),
    fixed = TRUE)

  # Testing center_max(data = df, col = NULL, shuffle_si...
  # Changed from baseline: shuffle_sides = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14622 <- xpectr::capture_side_effects(center_max(data = df, col = NULL, shuffle_sides = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'shuffle_sides': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'center_max'                                            ####
  #
})

test_that("fuzz testing center_min method for rearrange()", {
  xpectr::set_test_seed(42)

  # Create a data frame
  df <- data.frame(
    "index" = 1:9,
    "A" = sample(1:9),
    "B" = runif(9),
    "C" = LETTERS[1:9],
    stringsAsFactors = FALSE
  )

  # Generate expectations
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = center_min,
  #   args_values = list(
  #     "data" = list(df, head(df, 8), c(1,2,3,4,5,6,7), c(1,2,3,4),
  #                   factor(c(1,2,3,4,5,6,7,1,2,3)) ,list(1,2,3), NA, 1),
  #     "col" = list(NULL, "A", "B", "C"),
  #     "shuffle_sides" = list(FALSE, TRUE)
  #   ),
  #   extra_combinations = list(
  #     list("data" = c(1,2,3,4), "col" = "A")
  #   ),
  #   indentation = 2
  # )


  ## Testing 'center_min'                                                     ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing center_min(data = df, col = NULL, shuffle_si...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- center_min(data = df, col = NULL, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["index"]],
    c(9, 7, 5, 3, 1, 2, 4, 6, 8),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["A"]],
    c(2, 6, 4, 3, 9, 8, 5, 7, 1),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["B"]],
    c(0.11749, 0.94001, 0.25543, 0.71911, 0.70506, 0.45774, 0.93467,
      0.46229, 0.97823),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["C"]],
    c("I", "G", "E", "C", "A", "B", "D", "F", "H"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("index", "A", "B", "C"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "integer", "numeric", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "integer", "double", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(9L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing center_min(data = head(df, 8), col = NULL, s...
  # Changed from baseline: data = head(df, 8)
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- center_min(data = head(df, 8), col = NULL, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_19370),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19370[["index"]],
    c(8, 6, 4, 2, 1, 3, 5, 7),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["A"]],
    c(1, 7, 5, 8, 9, 3, 4, 6),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["B"]],
    c(0.97823, 0.46229, 0.93467, 0.45774, 0.70506, 0.71911, 0.25543,
      0.94001),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["C"]],
    c("H", "F", "D", "B", "A", "C", "E", "G"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19370),
    c("index", "A", "B", "C"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19370),
    c("integer", "integer", "numeric", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19370),
    c("integer", "integer", "double", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19370),
    c(8L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19370)),
    character(0),
    fixed = TRUE)

  # Testing center_min(data = c(1, 2, 3, 4, 5, 6, 7), co...
  # Changed from baseline: data = c(1, 2, 3, 4, ...
  xpectr::set_test_seed(42)
  # Assigning output
  output_12861 <- center_min(data = c(1, 2, 3, 4, 5, 6, 7), col = NULL, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_12861),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12861,
    type = "double")
  # Testing values
  expect_equal(
    output_12861,
    c(7, 5, 3, 1, 2, 4, 6),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_12861),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_12861),
    7L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_12861)),
    7L)

  # Testing center_min(data = c(1, 2, 3, 4), col = NULL,...
  # Changed from baseline: data = c(1, 2, 3, 4)
  xpectr::set_test_seed(42)
  # Assigning output
  output_18304 <- center_min(data = c(1, 2, 3, 4), col = NULL, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_18304),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_18304,
    type = "double")
  # Testing values
  expect_equal(
    output_18304,
    c(4, 2, 1, 3),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_18304),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_18304),
    4L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_18304)),
    4L)

  # Testing center_min(data = factor(c(1, 2, 3, 4, 5, 6,...
  # Changed from baseline: data = factor(c(1, 2,...
  xpectr::set_test_seed(42)
  # Assigning output
  output_16417 <- center_min(data = factor(c(1, 2, 3, 4, 5, 6, 7, 1, 2, 3)), col = NULL, shuffle_sides = FALSE)
  # Testing is factor
  expect_true(
    is.factor(output_16417))
  # Testing values
  expect_equal(
    as.character(output_16417),
    c("7", "5", "3", "2", "1", "1", "2", "3", "4", "6"),
    fixed = TRUE)
  # Testing names
  expect_equal(
    names(output_16417),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_16417),
    10L)
  # Testing number of levels
  expect_equal(
    nlevels(output_16417),
    7L)
  # Testing levels
  expect_equal(
    levels(output_16417),
    c("1", "2", "3", "4", "5", "6", "7"),
    fixed = TRUE)

  # Testing center_min(data = list(1, 2, 3), col = NULL,...
  # Changed from baseline: data = list(1, 2, 3)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(center_min(data = list(1, 2, 3), col = NULL, shuffle_sides = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, it cannot be a list."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing center_min(data = NA, col = NULL, shuffle_si...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(center_min(data = NA, col = NULL, shuffle_sides = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error']]),
    xpectr::strip(ifelse(
      is_checkmate_v2_1(),
      "Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'logical'\n * checkmate::check_vector(data): Contains missing values (element 1)\n * checkmate::check_factor(data): Must be of type 'factor', not 'logical'",
      "Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'logical'\n * checkmate::check_vector(data): Contains missing values (element 1)\n * checkmate::check_factor(data): Contains missing values (element 1)")),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing center_min(data = 1, col = NULL, shuffle_sid...
  # Changed from baseline: data = 1
  xpectr::set_test_seed(42)
  # Assigning output
  output_11346 <- center_min(data = 1, col = NULL, shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_11346),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_11346,
    type = "double")
  # Testing values
  expect_equal(
    output_11346,
    1,
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_11346),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_11346),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_11346)),
    1L)

  # Testing center_min(data = NULL, col = NULL, shuffle_...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(center_min(data = NULL, col = NULL, shuffle_sides = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'NULL'\n * checkmate::check_vector(data): Must be of type 'vector', not 'NULL'\n * checkmate::check_factor(data): Must be of type 'factor', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing center_min(data = c(1, 2, 3, 4), col = "A", ...
  # Changed from baseline: data, col
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(center_min(data = c(1, 2, 3, 4), col = "A", shuffle_sides = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing center_min(data = df, col = "C", shuffle_sid...
  # Changed from baseline: col = "C"
  xpectr::set_test_seed(42)
  # Assigning output
  output_14577 <- center_min(data = df, col = "C", shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_14577),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14577[["index"]],
    c(9, 7, 5, 3, 1, 2, 4, 6, 8),
    tolerance = 1e-4)
  expect_equal(
    output_14577[["A"]],
    c(2, 6, 4, 3, 9, 8, 5, 7, 1),
    tolerance = 1e-4)
  expect_equal(
    output_14577[["B"]],
    c(0.11749, 0.94001, 0.25543, 0.71911, 0.70506, 0.45774, 0.93467,
      0.46229, 0.97823),
    tolerance = 1e-4)
  expect_equal(
    output_14577[["C"]],
    c("I", "G", "E", "C", "A", "B", "D", "F", "H"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_14577),
    c("index", "A", "B", "C"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14577),
    c("integer", "integer", "numeric", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14577),
    c("integer", "integer", "double", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14577),
    c(9L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14577)),
    character(0),
    fixed = TRUE)

  # Testing center_min(data = df, col = "A", shuffle_sid...
  # Changed from baseline: col = "A"
  xpectr::set_test_seed(42)
  # Assigning output
  output_17191 <- center_min(data = df, col = "A", shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_17191),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17191[["index"]],
    c(1, 6, 4, 3, 8, 9, 5, 7, 2),
    tolerance = 1e-4)
  expect_equal(
    output_17191[["A"]],
    c(9, 7, 5, 3, 1, 2, 4, 6, 8),
    tolerance = 1e-4)
  expect_equal(
    output_17191[["B"]],
    c(0.70506, 0.46229, 0.93467, 0.71911, 0.97823, 0.11749, 0.25543,
      0.94001, 0.45774),
    tolerance = 1e-4)
  expect_equal(
    output_17191[["C"]],
    c("A", "F", "D", "C", "H", "I", "E", "G", "B"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_17191),
    c("index", "A", "B", "C"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17191),
    c("integer", "integer", "numeric", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17191),
    c("integer", "integer", "double", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17191),
    c(9L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17191)),
    character(0),
    fixed = TRUE)

  # Testing center_min(data = df, col = "B", shuffle_sid...
  # Changed from baseline: col = "B"
  xpectr::set_test_seed(42)
  # Assigning output
  output_19346 <- center_min(data = df, col = "B", shuffle_sides = FALSE)
  # Testing class
  expect_equal(
    class(output_19346),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19346[["index"]],
    c(8, 4, 1, 2, 9, 5, 6, 3, 7),
    tolerance = 1e-4)
  expect_equal(
    output_19346[["A"]],
    c(1, 5, 9, 8, 2, 4, 7, 3, 6),
    tolerance = 1e-4)
  expect_equal(
    output_19346[["B"]],
    c(0.97823, 0.93467, 0.70506, 0.45774, 0.11749, 0.25543, 0.46229,
      0.71911, 0.94001),
    tolerance = 1e-4)
  expect_equal(
    output_19346[["C"]],
    c("H", "D", "A", "B", "I", "E", "F", "C", "G"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19346),
    c("index", "A", "B", "C"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19346),
    c("integer", "integer", "numeric", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19346),
    c("integer", "integer", "double", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19346),
    c(9L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19346)),
    character(0),
    fixed = TRUE)

  # Testing center_min(data = df, col = NULL, shuffle_si...
  # Changed from baseline: shuffle_sides = TRUE
  xpectr::set_test_seed(42)
  # Assigning output
  output_12554 <- center_min(data = df, col = NULL, shuffle_sides = TRUE)
  # Testing class
  expect_equal(
    class(output_12554),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_12554[["index"]],
    c(8, 6, 5, 2, 1, 3, 4, 7, 9),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["A"]],
    c(1, 7, 4, 8, 9, 3, 5, 6, 2),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["B"]],
    c(0.97823, 0.46229, 0.25543, 0.45774, 0.70506, 0.71911, 0.93467,
      0.94001, 0.11749),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["C"]],
    c("H", "F", "E", "B", "A", "C", "D", "G", "I"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_12554),
    c("index", "A", "B", "C"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_12554),
    c("integer", "integer", "numeric", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_12554),
    c("integer", "integer", "double", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12554),
    c(9L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_12554)),
    character(0),
    fixed = TRUE)

  # Testing center_min(data = df, col = NULL, shuffle_si...
  # Changed from baseline: shuffle_sides = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14622 <- xpectr::capture_side_effects(center_min(data = df, col = NULL, shuffle_sides = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'shuffle_sides': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'center_min'                                            ####
  #

})

# TODO add more edge cases
test_that("edge cases for center_max()", {
  xpectr::set_test_seed(42)


  ## Testing 'center_max(data = c(1))'                                      ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- center_max(data = c(1))
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    1,
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    1L)
  ## Finished testing 'center_max(data = c(1))'                             ####


  ## Testing 'center_max(data = c(1,1,1))'                                  ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- center_max(data = c(1,1,1))
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(1, 1, 1),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)
  ## Finished testing 'center_max(data = c(1,1,1))'                         ####


  ## Testing 'center_max(data = c(-10, 10, NA))'                            ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(center_max(data = c(-10, 10, NA)), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'double'\n * checkmate::check_vector(data): Contains missing values (element 3)\n * checkmate::check_factor(data): Must be of type 'factor', not 'double'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'center_max(data = c(-10, 10, NA))'                   ####


  ## Testing 'center_max( data = dplyr::tibble( "a" = c(1,...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- center_max(
      data = dplyr::tibble(
        "a" = c(1, 2, 3, 4, 5, 6),
        "b" = c(1, 1, 1, 2, 2, 2)) %>%
        dplyr::group_by(b),
      col = "a")
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["a"]],
    c(1, 3, 2, 4, 6, 5),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["b"]],
    c(1, 1, 1, 2, 2, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("a", "b"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(6L, 2L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'center_max( data = dplyr::tibble( "a" = c(1,...'     ####


})
