library(rearrr)
context("swirl_2d()")


test_that("fuzz testing swirl_2d()", {
  xpectr::set_test_seed(42)

  # Create a data frame
  df <- data.frame(
    "x" = runif(15),
    "y" = runif(15),
    "z" = runif(15),
    "g" = rep(c(1, 2, 3, 4, 5), each = 3),
    stringsAsFactors = FALSE
  ) %>%
    dplyr::as_tibble()

  # Generate expectations for 'swirl_2d'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = swirl_2d,
  #   args_values = list(
  #     "data" = list(df, dplyr::group_by(df, g), c(1, 2, 3, 4, 5), "hej", NA),
  #     "radius" = list(1, 0, -1, 10, c(1, 2, 3), NA),
  #     "x_col" = list("x", "y", NA),
  #     "y_col" = list("y", "x", NA),
  #     "suffix" = list("", "_swirled", NA),
  #     "origin" = list(c(0, 0), c(NA, 0), c(0, 0, 0), NA),
  #     "origin_fn" = list(NULL, centroid, most_centered),
  #     "scale_fn" = list(identity, function(d){d^1.5}, function(d){c(d, d+1)}),
  #     "keep_original" = list(FALSE),
  #     "degrees_col_name" = list(".degrees", ".deg"),
  #     "radius_col_name" = list(".radius", ".rad"),
  #     "origin_col_name" = list(".origin", ".origi"),
  #     "overwrite" = list(TRUE, FALSE)
  #   ),
  #   extra_combinations = list(
  #     list("data" = c(1, 2, 3, 4, 5), "x_col" = NULL, "y_col" = NULL, "origin_fn" = centroid, "origin" = NULL),
  #     list("data" = c(1, 2, 3, 4, 5), "x_col" = "x", "y_col" = NULL, "origin_fn" = centroid, "origin" = NULL),
  #     list("data" = dplyr::group_by(df, g), "origin_fn" = centroid),
  #     list("keep_original" = TRUE, "suffix" = "_swirly"),
  #     list("overwrite" = FALSE, "radius_col_name" = "g"),
  #     list("degrees_col_name" = "popop", "radius_col_name" = "popop")
  #   ),
  #   indentation = 2
  # )


  ## Testing 'swirl_2d'                                                       ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["x"]],
    c(0.27004, 0.46476, 0.06431, -0.8872, -0.8249, -0.39424, -0.61831,
      -0.14082, -0.14731, -0.49707, -0.68213, -0.81591, 0.18955, -0.45836,
      -0.57473),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    c(-1.28358, -1.27241, 0.30256, -0.35798, -0.21296, -0.96504, 0.42367,
      -0.98803, -1.14286, 0.50679, 0.09292, 0.06058, -1.28765, 0.23437,
      -0.76309),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".degrees"]],
    c(236.10192, 243.83439, 55.67767, 172.20512, 153.35008, 187.64371,
      134.91632, 179.64342, 207.4159, 127.7762, 123.91811, 147.26829,
      234.27495, 92.66517, 171.95585),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".radius"]],
    c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("x", "y", ".origin", ".degrees", ".radius"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric", "list", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double", "list", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing swirl_2d(data = dplyr::group_by(df, g), radi...
  # Changed from baseline: data = dplyr::group_b...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- swirl_2d(data = dplyr::group_by(df, g), radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19370),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19370[["x"]],
    c(0.27004, 0.46476, 0.06431, -0.8872, -0.8249, -0.39424, -0.61831,
      -0.14082, -0.14731, -0.49707, -0.68213, -0.81591, 0.18955, -0.45836,
      -0.57473),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["y"]],
    c(-1.28358, -1.27241, 0.30256, -0.35798, -0.21296, -0.96504, 0.42367,
      -0.98803, -1.14286, 0.50679, 0.09292, 0.06058, -1.28765, 0.23437,
      -0.76309),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    output_19370[[".degrees"]],
    c(236.10192, 243.83439, 55.67767, 172.20512, 153.35008, 187.64371,
      134.91632, 179.64342, 207.4159, 127.7762, 123.91811, 147.26829,
      234.27495, 92.66517, 171.95585),
    tolerance = 1e-4)
  expect_equal(
    output_19370[[".radius"]],
    c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19370),
    c("g", "x", "y", ".origin", ".degrees", ".radius"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19370),
    c("numeric", "numeric", "numeric", "list", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19370),
    c("double", "double", "double", "list", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19370),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19370)),
    character(0),
    fixed = TRUE)

  # Testing swirl_2d(data = c(1, 2, 3, 4, 5), radius = 1...
  # Changed from baseline: data = c(1, 2, 3, 4, 5)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(swirl_2d(data = c(1, 2, 3, 4, 5), radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = "hej", radius = 1, x_col = "...
  # Changed from baseline: data = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(swirl_2d(data = "hej", radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = NA, radius = 1, x_col = "x",...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(swirl_2d(data = NA, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'logical'\n * checkmate::check_vector(data): Contains missing values (element 1)\n * checkmate::check_factor(data): Contains missing values (element 1)"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = NULL, radius = 1, x_col = "x...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(swirl_2d(data = NULL, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'NULL'\n * checkmate::check_vector(data): Must be of type 'vector', not 'NULL'\n * checkmate::check_factor(data): Must be of type 'factor', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = dplyr::group_by(df, g), radi...
  # Changed from baseline: data, origin_fn
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(swirl_2d(data = dplyr::group_by(df, g), radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = centroid, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['warnings']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['messages']]),
    xpectr::strip("When 'origin_fn' is specified, 'origin' is ignored.\n"),
    fixed = TRUE)
  # Assigning output
  output_17365 <- xpectr::suppress_mw(swirl_2d(data = dplyr::group_by(df, g), radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = centroid, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE))
  # Testing class
  expect_equal(
    class(output_17365),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17365[["x"]],
    c(0.59009, 0.52235, 1.41746, 0.90261, 0.66634, 0.37087, 0.96781,
      0.18729, 0.39405, 0.8597, 0.37637, 0.69283, 0.47254, 0.73839,
      0.42569),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["y"]],
    c(0.98546, 1.00095, 0.67394, 0.63491, 0.5576, 0.68503, 1.0748, 0.33765,
      0.96275, 0.21578, 0.33915, 0.41776, 1.14463, 0.36637, 0.78881),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    output_17365[[".degrees"]],
    c(59.48382, 67.38505, 126.86514, 43.04264, 16.00037, 53.17616, 107.56401,
      86.12287, 53.07064, 46.52756, 45.20606, 19.86552, 76.02618,
      73.58154, 24.91636),
    tolerance = 1e-4)
  expect_equal(
    output_17365[[".radius"]],
    c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17365),
    c("g", "x", "y", ".origin", ".degrees", ".radius"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17365),
    c("numeric", "numeric", "numeric", "list", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17365),
    c("double", "double", "double", "list", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17365)),
    character(0),
    fixed = TRUE)

  # Testing swirl_2d(data = c(1, 2, 3, 4, 5), radius = 1...
  # Changed from baseline: data, x_col, y_col, o...
  xpectr::set_test_seed(42)
  # Assigning output
  output_11346 <- swirl_2d(data = c(1, 2, 3, 4, 5), radius = 1, x_col = NULL, y_col = NULL, suffix = "", origin = NULL, origin_fn = centroid, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_11346),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11346[["Index"]],
    c(5.74301, 2.30235, 3, 3.69765, 0.25699),
    tolerance = 1e-4)
  expect_equal(
    output_11346[["Value"]],
    c(3.68986, 4.23016, 3, 1.76984, 2.31014),
    tolerance = 1e-4)
  expect_equal(
    output_11346[[".degrees"]],
    c(149.11688, 254.55844, 0, 254.55844, 149.11688),
    tolerance = 1e-4)
  expect_equal(
    output_11346[[".radius"]],
    c(1, 1, 1, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11346),
    c("Index", "Value", ".origin", ".degrees", ".radius"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11346),
    c("numeric", "numeric", "list", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11346),
    c("double", "double", "list", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11346),
    c(5L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11346)),
    character(0),
    fixed = TRUE)

  # Testing swirl_2d(data = c(1, 2, 3, 4, 5), radius = 1...
  # Changed from baseline: data, x_col, y_col, o...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(swirl_2d(data = c(1, 2, 3, 4, 5), radius = 1, x_col = "x", y_col = NULL, suffix = "", origin = NULL, origin_fn = centroid, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 0, x_col = "x",...
  # Changed from baseline: radius = 0
  xpectr::set_test_seed(42)
  # Assigning output
  output_17050 <- swirl_2d(data = df, radius = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17050),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17050[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_17050[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_17050[[".degrees"]],
    c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    output_17050[[".radius"]],
    c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17050),
    c("x", "y", ".origin", ".degrees", ".radius"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17050),
    c("numeric", "numeric", "list", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17050),
    c("double", "double", "list", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17050),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17050)),
    character(0),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = -1, x_col = "x"...
  # Changed from baseline: radius = -1
  xpectr::set_test_seed(42)
  # Assigning output
  output_14577 <- swirl_2d(data = df, radius = -1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14577),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14577[["x"]],
    c(-1.29044, -1.2912, 0.25837, -0.75835, -0.32224, -0.63473, -0.42186,
      -0.12851, -1.01909, -0.36675, 0.17129, -0.39394, -1.28106, 0.43461,
      -0.34076),
    tolerance = 1e-4)
  expect_equal(
    output_14577[["y"]],
    c(0.23505, 0.40968, -0.17007, -0.58324, -0.78865, -0.82695, -0.61955,
      -0.98971, -0.53784, -0.60779, -0.66678, -0.71707, 0.22994, -0.27594,
      -0.89247),
    tolerance = 1e-4)
  expect_equal(
    output_14577[[".degrees"]],
    c(123.89808, 116.16561, 304.32233, 187.79488, 206.64992, 172.35629,
      225.08368, 180.35658, 152.5841, 232.2238, 236.08189, 212.73171,
      125.72505, 267.33483, 188.04415),
    tolerance = 1e-4)
  expect_equal(
    output_14577[[".radius"]],
    c(-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_14577),
    c("x", "y", ".origin", ".degrees", ".radius"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14577),
    c("numeric", "numeric", "list", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14577),
    c("double", "double", "list", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14577),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14577)),
    character(0),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 10, x_col = "x"...
  # Changed from baseline: radius = 10
  xpectr::set_test_seed(42)
  # Assigning output
  output_17191 <- swirl_2d(data = df, radius = 10, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17191),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17191[["x"]],
    c(0.46174, 0.44964, 0.27339, 0.6526, 0.47071, 0.2007, 0.6839, -0.1769,
      0.27914, 0.66937, 0.33673, 0.59629, 0.49751, 0.18012, 0.19448),
    tolerance = 1e-4)
  expect_equal(
    output_17191[["y"]],
    c(1.22772, 1.27783, 0.1447, 0.69956, 0.7101, 1.02296, 0.30673, 0.98222,
      1.11799, 0.23633, 0.60046, 0.56019, 1.20269, 0.48227, 0.93531),
    tolerance = 1e-4)
  expect_equal(
    output_17191[[".degrees"]],
    c(23.61019, 24.38344, 5.56777, 17.22051, 15.33501, 18.76437, 13.49163,
      17.96434, 20.74159, 12.77762, 12.39181, 14.72683, 23.42749,
      9.26652, 17.19559),
    tolerance = 1e-4)
  expect_equal(
    output_17191[[".radius"]],
    c(10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17191),
    c("x", "y", ".origin", ".degrees", ".radius"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17191),
    c("numeric", "numeric", "list", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17191),
    c("double", "double", "list", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17191),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17191)),
    character(0),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = c(1, 2, 3), x_c...
  # Changed from baseline: radius = c(1, 2, 3)
  xpectr::set_test_seed(42)
  # Assigning output
  output_19346 <- swirl_2d(data = df, radius = c(1, 2, 3), x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19346),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_19346[["x"]], n = 30),
    c(0.46476, -0.8872, -0.39424, -0.14082, -0.14731, -0.68213, 0.18955,
      -0.45836, -0.57473, -1.32576, -0.41745, -0.93662, -0.98847,
      0.23629, -0.23866, -0.17177, -1.23236, -0.14695, -0.80152, -0.74255,
      0.23386, 0.04723, -0.03333, 0.42306, -0.65065, 0.46327, 0.17604,
      -0.69338, -0.01026, -0.45403),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19346[["y"]], n = 30),
    c(-1.27241, -0.35798, -0.96504, -0.98803, -1.14286, 0.09292, -1.28765,
      0.23437, -0.76309, 0.27822, 0.86081, 0.45768, 0.13774, 0.66939,
      0.64574, 0.79992, 0.41865, 0.49339, 0.51979, 1.08126, 0.20245,
      0.95553, 0.85129, 0.61872, 0.95104, 0.53786, 0.79899, 1.10145,
      0.5147, 0.84052),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19346[[".degrees"]], n = 30),
    c(243.83439, 172.20512, 187.64371, 179.64342, 207.4159, 123.91811,
      234.27495, 92.66517, 171.95585, 121.91719, 86.10256, 93.82185,
      89.82171, 63.8881, 61.95905, 73.63415, 117.13747, 46.33259,
      85.97793, 78.70064, 18.55922, 57.40171, 51.11669, 44.97211,
      69.13863, 42.59207, 49.08943, 78.09165, 30.88839, 57.31862),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19346[[".radius"]], n = 30),
    c(1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3,
      3, 3, 3, 3, 3, 3, 3, 3, 3),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19346),
    c("x", "y", ".origin", ".degrees", ".radius"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19346),
    c("numeric", "numeric", "list", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19346),
    c("double", "double", "list", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19346),
    c(45L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19346)),
    character(0),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = NA, x_col = "x"...
  # Changed from baseline: radius = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = NA, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'radius': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = NULL, x_col = "...
  # Changed from baseline: radius = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14622 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = NULL, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'radius': Must be of type 'numeric', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "y",...
  # Changed from baseline: x_col = "y"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = "y", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("1 assertions failed:\n * 'x_col' and 'y_col' cannot be the same column."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = NA, ...
  # Changed from baseline: x_col = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = NA, y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = NULL...
  # Changed from baseline: x_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11174 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = NULL, y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is a data.frame, 'x_col' must be specified."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: y_col = "x"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14749 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = "x", y_col = "x", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error']]),
    xpectr::strip("1 assertions failed:\n * 'x_col' and 'y_col' cannot be the same column."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: y_col = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15603 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = "x", y_col = NA, suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_col': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: y_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19040 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = "x", y_col = NULL, suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is a data.frame, 'y_col' must be specified."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: suffix = "_swirled"
  xpectr::set_test_seed(42)
  # Assigning output
  output_11387 <- swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "_swirled", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_11387),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11387[["x_swirled"]],
    c(0.27004, 0.46476, 0.06431, -0.8872, -0.8249, -0.39424, -0.61831,
      -0.14082, -0.14731, -0.49707, -0.68213, -0.81591, 0.18955, -0.45836,
      -0.57473),
    tolerance = 1e-4)
  expect_equal(
    output_11387[["y_swirled"]],
    c(-1.28358, -1.27241, 0.30256, -0.35798, -0.21296, -0.96504, 0.42367,
      -0.98803, -1.14286, 0.50679, 0.09292, 0.06058, -1.28765, 0.23437,
      -0.76309),
    tolerance = 1e-4)
  expect_equal(
    output_11387[[".degrees"]],
    c(236.10192, 243.83439, 55.67767, 172.20512, 153.35008, 187.64371,
      134.91632, 179.64342, 207.4159, 127.7762, 123.91811, 147.26829,
      234.27495, 92.66517, 171.95585),
    tolerance = 1e-4)
  expect_equal(
    output_11387[[".radius"]],
    c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11387),
    c("x_swirled", "y_swirled", ".origin", ".degrees", ".radius"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11387),
    c("numeric", "numeric", "list", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11387),
    c("double", "double", "list", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11387),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11387)),
    character(0),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: suffix = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19888 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = NA, origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: suffix = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19466 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = NULL, origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: suffix, keep_original
  xpectr::set_test_seed(42)
  # Assigning output
  output_10824 <- swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "_swirly", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = TRUE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_10824),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_10824[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_10824[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_10824[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_10824[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    output_10824[["x_swirly"]],
    c(0.27004, 0.46476, 0.06431, -0.8872, -0.8249, -0.39424, -0.61831,
      -0.14082, -0.14731, -0.49707, -0.68213, -0.81591, 0.18955, -0.45836,
      -0.57473),
    tolerance = 1e-4)
  expect_equal(
    output_10824[["y_swirly"]],
    c(-1.28358, -1.27241, 0.30256, -0.35798, -0.21296, -0.96504, 0.42367,
      -0.98803, -1.14286, 0.50679, 0.09292, 0.06058, -1.28765, 0.23437,
      -0.76309),
    tolerance = 1e-4)
  expect_equal(
    output_10824[[".degrees"]],
    c(236.10192, 243.83439, 55.67767, 172.20512, 153.35008, 187.64371,
      134.91632, 179.64342, 207.4159, 127.7762, 123.91811, 147.26829,
      234.27495, 92.66517, 171.95585),
    tolerance = 1e-4)
  expect_equal(
    output_10824[[".radius"]],
    c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_10824),
    c("x", "y", "z", "g", "x_swirly", "y_swirly", ".origin", ".degrees",
      ".radius"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_10824),
    c("numeric", "numeric", "numeric", "numeric", "numeric", "numeric",
      "list", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_10824),
    c("double", "double", "double", "double", "double", "double", "list",
      "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_10824),
    c(15L, 9L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_10824)),
    character(0),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: origin = c(NA, 0)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15142 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(NA, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: origin = c(0, 0, 0)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13902 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13902[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Must have length 2, but has length 3."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13902[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: origin = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19057 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = NA, origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Must have length 2, but has length 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: origin = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14469 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = NULL, origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error']]),
    xpectr::strip("1 assertions failed:\n * At least one of {'origin', 'origin_fn'} must be specified (not 'NULL')."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: origin_fn = centroid
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18360 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = centroid, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['warnings']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['messages']]),
    xpectr::strip("When 'origin_fn' is specified, 'origin' is ignored.\n"),
    fixed = TRUE)
  # Assigning output
  output_18360 <- xpectr::suppress_mw(swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = centroid, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE))
  # Testing class
  expect_equal(
    class(output_18360),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_18360[["x"]],
    c(0.34601, 0.26318, 1.18444, 0.86408, 0.65176, 0.32277, 1.092, 0.41746,
      0.34684, 1.12934, 0.53849, 0.84657, 0.39483, 0.65587, 0.34777),
    tolerance = 1e-4)
  expect_equal(
    output_18360[["y"]],
    c(0.9695, 0.95392, 0.44936, 0.67687, 0.56695, 0.70559, 0.72695,
      0.04032, 0.81805, 0.77409, 0.44565, 0.53024, 0.99001, 0.22246,
      0.65044),
    tolerance = 1e-4)
  expect_equal(
    output_18360[[".degrees"]],
    c(79.86213, 87.64674, 107.12877, 46.58269, 11.13428, 54.69183, 88.57992,
      109.25304, 60.229, 97.28859, 33.28667, 44.76009, 78.07497, 71.08074,
      48.12936),
    tolerance = 1e-4)
  expect_equal(
    output_18360[[".radius"]],
    c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_18360),
    c("x", "y", ".origin", ".degrees", ".radius"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_18360),
    c("numeric", "numeric", "list", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_18360),
    c("double", "double", "list", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_18360),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_18360)),
    character(0),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: origin_fn = most_cent...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17375 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = most_centered, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['warnings']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['messages']]),
    xpectr::strip("When 'origin_fn' is specified, 'origin' is ignored.\n"),
    fixed = TRUE)
  # Assigning output
  output_17375 <- xpectr::suppress_mw(swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = most_centered, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE))
  # Testing class
  expect_equal(
    class(output_17375),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17375[["x"]],
    c(0.2917, 0.21327, 1.14988, 0.84358, 0.64175, 0.27803, 1.07389,
      0.51851, 0.28497, 1.12245, 0.51535, 0.8004, 0.34331, 0.63348,
      0.31307),
    tolerance = 1e-4)
  expect_equal(
    output_17375[["y"]],
    c(0.87048, 0.84008, 0.30662, 0.60672, 0.56033, 0.59007, 0.56385,
      -0.09205, 0.70932, 0.59665, 0.41888, 0.46156, 0.90099, 0.15781,
      0.5473),
    tolerance = 1e-4)
  expect_equal(
    output_17375[[".degrees"]],
    c(84.18158, 92.10916, 102.23107, 37.27811, 0, 65.68685, 77.78849,
      119.50588, 69.59452, 86.77291, 34.14526, 33.64102, 81.52052,
      72.46912, 59.20825),
    tolerance = 1e-4)
  expect_equal(
    output_17375[[".radius"]],
    c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17375),
    c("x", "y", ".origin", ".degrees", ".radius"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17375),
    c("numeric", "numeric", "list", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17375),
    c("double", "double", "list", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17375),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17375)),
    character(0),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: scale_fn = function(d...
  xpectr::set_test_seed(42)
  # Assigning output
  output_18110 <- swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = function(d) {
      d^1.5
  }, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_18110),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_18110[["x"]],
    c(0.94644, 1.17347, 0.18491, -0.90881, -0.85102, -0.32695, -0.45597,
      -0.14389, 0.15821, -0.2924, -0.60295, -0.77674, 0.86022, -0.30795,
      -0.62513),
    tolerance = 1e-4)
  expect_equal(
    output_18110[["y"]],
    c(-0.90816, -0.67677, 0.24797, -0.29887, -0.03967, -0.98987, 0.59489,
      -0.98759, -1.1414, 0.64685, 0.33226, 0.257, -0.97673, 0.41254,
      -0.72238),
    tolerance = 1e-4)
  expect_equal(
    output_18110[[".degrees"]],
    c(270.40394, 283.79594, 30.96602, 168.43519, 141.54344, 191.58643,
      116.80474, 179.4654, 222.65211, 107.65612, 102.81723, 133.20718,
      267.27142, 66.48728, 168.06961),
    tolerance = 1e-4)
  expect_equal(
    output_18110[[".radius"]],
    c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_18110),
    c("x", "y", ".origin", ".degrees", ".radius"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_18110),
    c("numeric", "numeric", "list", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_18110),
    c("double", "double", "list", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_18110),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_18110)),
    character(0),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: scale_fn = function(d...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13881 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = function(d) {
      c(d, d + 1)
  }, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13881[['error']]),
    xpectr::strip("the output of 'scale_fn' must have the same length as the input."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13881[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: scale_fn = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16851 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'scale_fn': Must be a function, not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: keep_original = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10039 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = NULL, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10039[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10039[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: degrees_col_name = "....
  xpectr::set_test_seed(42)
  # Assigning output
  output_18329 <- swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".deg", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_18329),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_18329[["x"]],
    c(0.27004, 0.46476, 0.06431, -0.8872, -0.8249, -0.39424, -0.61831,
      -0.14082, -0.14731, -0.49707, -0.68213, -0.81591, 0.18955, -0.45836,
      -0.57473),
    tolerance = 1e-4)
  expect_equal(
    output_18329[["y"]],
    c(-1.28358, -1.27241, 0.30256, -0.35798, -0.21296, -0.96504, 0.42367,
      -0.98803, -1.14286, 0.50679, 0.09292, 0.06058, -1.28765, 0.23437,
      -0.76309),
    tolerance = 1e-4)
  expect_equal(
    output_18329[[".deg"]],
    c(236.10192, 243.83439, 55.67767, 172.20512, 153.35008, 187.64371,
      134.91632, 179.64342, 207.4159, 127.7762, 123.91811, 147.26829,
      234.27495, 92.66517, 171.95585),
    tolerance = 1e-4)
  expect_equal(
    output_18329[[".radius"]],
    c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_18329),
    c("x", "y", ".origin", ".deg", ".radius"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_18329),
    c("numeric", "numeric", "list", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_18329),
    c("double", "double", "list", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_18329),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_18329)),
    character(0),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: degrees_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_10073 <- swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = NULL, radius_col_name = ".radius", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_10073),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_10073[["x"]],
    c(0.27004, 0.46476, 0.06431, -0.8872, -0.8249, -0.39424, -0.61831,
      -0.14082, -0.14731, -0.49707, -0.68213, -0.81591, 0.18955, -0.45836,
      -0.57473),
    tolerance = 1e-4)
  expect_equal(
    output_10073[["y"]],
    c(-1.28358, -1.27241, 0.30256, -0.35798, -0.21296, -0.96504, 0.42367,
      -0.98803, -1.14286, 0.50679, 0.09292, 0.06058, -1.28765, 0.23437,
      -0.76309),
    tolerance = 1e-4)
  expect_equal(
    output_10073[[".radius"]],
    c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_10073),
    c("x", "y", ".origin", ".radius"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_10073),
    c("numeric", "numeric", "list", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_10073),
    c("double", "double", "list", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_10073),
    c(15L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_10073)),
    character(0),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: degrees_col_name, rad...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12076 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = "popop", radius_col_name = "popop", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12076[['error']]),
    xpectr::strip("Assertion on 'specified column names (\"x\", \"y\", \"popop\", \".origin\", ...)' failed: Contains duplicated values, position 5."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12076[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: radius_col_name = ".rad"
  xpectr::set_test_seed(42)
  # Assigning output
  output_19066 <- swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".rad", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19066),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19066[["x"]],
    c(0.27004, 0.46476, 0.06431, -0.8872, -0.8249, -0.39424, -0.61831,
      -0.14082, -0.14731, -0.49707, -0.68213, -0.81591, 0.18955, -0.45836,
      -0.57473),
    tolerance = 1e-4)
  expect_equal(
    output_19066[["y"]],
    c(-1.28358, -1.27241, 0.30256, -0.35798, -0.21296, -0.96504, 0.42367,
      -0.98803, -1.14286, 0.50679, 0.09292, 0.06058, -1.28765, 0.23437,
      -0.76309),
    tolerance = 1e-4)
  expect_equal(
    output_19066[[".degrees"]],
    c(236.10192, 243.83439, 55.67767, 172.20512, 153.35008, 187.64371,
      134.91632, 179.64342, 207.4159, 127.7762, 123.91811, 147.26829,
      234.27495, 92.66517, 171.95585),
    tolerance = 1e-4)
  expect_equal(
    output_19066[[".rad"]],
    c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19066),
    c("x", "y", ".origin", ".degrees", ".rad"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19066),
    c("numeric", "numeric", "list", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19066),
    c("double", "double", "list", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19066),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19066)),
    character(0),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: radius_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_16117 <- swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = NULL, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_16117),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16117[["x"]],
    c(0.27004, 0.46476, 0.06431, -0.8872, -0.8249, -0.39424, -0.61831,
      -0.14082, -0.14731, -0.49707, -0.68213, -0.81591, 0.18955, -0.45836,
      -0.57473),
    tolerance = 1e-4)
  expect_equal(
    output_16117[["y"]],
    c(-1.28358, -1.27241, 0.30256, -0.35798, -0.21296, -0.96504, 0.42367,
      -0.98803, -1.14286, 0.50679, 0.09292, 0.06058, -1.28765, 0.23437,
      -0.76309),
    tolerance = 1e-4)
  expect_equal(
    output_16117[[".degrees"]],
    c(236.10192, 243.83439, 55.67767, 172.20512, 153.35008, 187.64371,
      134.91632, 179.64342, 207.4159, 127.7762, 123.91811, 147.26829,
      234.27495, 92.66517, 171.95585),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_16117),
    c("x", "y", ".origin", ".degrees"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16117),
    c("numeric", "numeric", "list", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16117),
    c("double", "double", "list", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16117),
    c(15L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16117)),
    character(0),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: radius_col_name, over...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13795 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = "g", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13795[['error']]),
    xpectr::strip("1 assertions failed:\n * The column 'g' already exists and 'overwrite' is disabled."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13795[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: origin_col_name = ".o...
  xpectr::set_test_seed(42)
  # Assigning output
  output_14357 <- swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origi", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14357),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14357[["x"]],
    c(0.27004, 0.46476, 0.06431, -0.8872, -0.8249, -0.39424, -0.61831,
      -0.14082, -0.14731, -0.49707, -0.68213, -0.81591, 0.18955, -0.45836,
      -0.57473),
    tolerance = 1e-4)
  expect_equal(
    output_14357[["y"]],
    c(-1.28358, -1.27241, 0.30256, -0.35798, -0.21296, -0.96504, 0.42367,
      -0.98803, -1.14286, 0.50679, 0.09292, 0.06058, -1.28765, 0.23437,
      -0.76309),
    tolerance = 1e-4)
  expect_equal(
    output_14357[[".degrees"]],
    c(236.10192, 243.83439, 55.67767, 172.20512, 153.35008, 187.64371,
      134.91632, 179.64342, 207.4159, 127.7762, 123.91811, 147.26829,
      234.27495, 92.66517, 171.95585),
    tolerance = 1e-4)
  expect_equal(
    output_14357[[".radius"]],
    c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_14357),
    c("x", "y", ".origi", ".degrees", ".radius"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14357),
    c("numeric", "numeric", "list", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14357),
    c("double", "double", "list", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14357),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14357)),
    character(0),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: origin_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_10374 <- swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_10374),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_10374[["x"]],
    c(0.27004, 0.46476, 0.06431, -0.8872, -0.8249, -0.39424, -0.61831,
      -0.14082, -0.14731, -0.49707, -0.68213, -0.81591, 0.18955, -0.45836,
      -0.57473),
    tolerance = 1e-4)
  expect_equal(
    output_10374[["y"]],
    c(-1.28358, -1.27241, 0.30256, -0.35798, -0.21296, -0.96504, 0.42367,
      -0.98803, -1.14286, 0.50679, 0.09292, 0.06058, -1.28765, 0.23437,
      -0.76309),
    tolerance = 1e-4)
  expect_equal(
    output_10374[[".degrees"]],
    c(236.10192, 243.83439, 55.67767, 172.20512, 153.35008, 187.64371,
      134.91632, 179.64342, 207.4159, 127.7762, 123.91811, 147.26829,
      234.27495, 92.66517, 171.95585),
    tolerance = 1e-4)
  expect_equal(
    output_10374[[".radius"]],
    c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_10374),
    c("x", "y", ".degrees", ".radius"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_10374),
    c("numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_10374),
    c("double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_10374),
    c(15L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_10374)),
    character(0),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: overwrite = FALSE
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19735 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19735[['error']]),
    xpectr::strip("Adding these dimensions would overwrite existing columns: x, y."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19735[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing swirl_2d(data = df, radius = 1, x_col = "x",...
  # Changed from baseline: overwrite = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14317 <- xpectr::capture_side_effects(swirl_2d(data = df, radius = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, scale_fn = identity, keep_original = FALSE, degrees_col_name = ".degrees", radius_col_name = ".radius", origin_col_name = ".origin", overwrite = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14317[['error']]),
    xpectr::strip("Assertion on 'overwrite' failed: Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14317[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'swirl_2d'                                              ####
  #
})
