% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulators.R
\name{sd_sensitivity_run}
\alias{sd_sensitivity_run}
\title{Perform a sensitivity run on a System Dynamics model}
\usage{
sd_sensitivity_run(
  ds_inputs,
  consts_df = NULL,
  stocks_df = NULL,
  start_time = NULL,
  stop_time = NULL,
  timestep = NULL,
  integ_method = "euler",
  multicore = FALSE,
  n_cores = NULL
)
}
\arguments{
\item{ds_inputs}{A list of deSolve inputs generated by read_xmile}

\item{consts_df}{A data frame that contains the values of constants to
simulate. Each column corresponds to a constant and each row to an
iteration.}

\item{stocks_df}{A data frame that containts the initial value of stocks to
be explored. Each column corresponds to a stock and each row to an iteration.}

\item{start_time}{A number}

\item{stop_time}{A number}

\item{timestep}{A number}

\item{integ_method}{A string. Either "euler" or "rk4"}

\item{multicore}{A boolean value that indicates whether the process
is parallelised. This option only works for Unix-based systems.}

\item{n_cores}{An integer.}
}
\value{
A data frame
}
\description{
\code{sd_sensitivity_run} returns a data frame with the simulation of a
model for several iterations of different inputs.
}
\examples{
path      <- system.file("models", "SIR.stmx", package = "readsdr")
ds_inputs <- xmile_to_deSolve(path)
consts_df <- data.frame(i = c(0.25, 0.30))
sd_sensitivity_run(ds_inputs, consts_df)
}
