% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dhis2-helpers.R
\name{get_organisation_units}
\alias{get_organisation_units}
\title{Get the organization units from a specific DHIS2 instance}
\usage{
get_organisation_units(login)
}
\arguments{
\item{login}{A httr2_response object returned by the \code{dhis2_login()} function}
}
\value{
A data frame where each row represents a full hierarchy for the
last-level unit by keeping the hierarchical organizational unit's name and
ID at each level, using the official level names provided by the DHIS2
instance like "Country Name", "Country ID", etc.
}
\description{
Retrieves all organisational reporting units and their levels,
then builds a hierarchy for each unit by tracing its ancestries from
the deepest level up to the root.
}
\details{
\enumerate{
\item Fetches all organisation units via the \code{get_org_units()} function,
\item Fetches all organisational unit levels via the \code{get_org_unit_levels()}
function,
\item Filters for organisational units at the deepest level,
\item Traces the parent hierarchy of each deepest unit up to the root,
\item Constructs a tabular structure where each row is a full lineage.
}
}
\examples{
\dontrun{
  # establish the connection to the system
  dhis2_login <- login(
    type = "dhis2",
    from = "https://smc.moh.gm/dhis",
    user_name = "test",
    password = "Gambia@123"
  )

  # fetch the organisation units
  org_units <- get_organisation_units(login = dhis2_login)
}

}
