% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dhis2-helpers.R
\name{get_data_elements}
\alias{get_data_elements}
\title{Get all data elements from a specific DHIS2 instance}
\usage{
get_data_elements(login)
}
\arguments{
\item{login}{A httr2_response object returned by the \code{dhis2_login()} function}
}
\value{
A data frame with the following two columns: the data elements IDs
and their corresponding names.
}
\description{
Get all data elements from a specific DHIS2 instance
}
\examples{
\dontrun{
  # establish the connection to the system
  dhis2_login <- login(
    type = "dhis2",
    from = "https://smc.moh.gm/dhis",
    user_name = "test",
    password = "Gambia@123"
  )

  # retrieve the data elements
  data_elements <- get_data_elements(login = dhis2_login)
}

}
