% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bci2000.R
\name{read_bci2000}
\alias{read_bci2000}
\alias{read_bci2000_header}
\title{Read \code{'BCI2000'} recording data}
\usage{
read_bci2000_header(file)

read_bci2000(file)
}
\arguments{
\item{file}{path to the recording data}
}
\value{
Parsed signal data
}
\description{
Read \code{'BCI2000'} recording data
}
\examples{

# Package comes with sample data
file <- system.file("samples", "bci2000_sample.dat", package = "readNSx")
result <- read_bci2000(file)

print(result)

# Notive: v1.0 and v1.1 are different, but all in `Source` section
# sample rate
result$parameters$Source$SamplingRate$value

# Signal data 64 channels x 500 time-points
dim(result$signals)

}
