% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt3x_sample_data.R
\name{gt3x_datapath}
\alias{gt3x_datapath}
\alias{gt3x_filename}
\title{Path to read.gt3x package sample data}
\usage{
gt3x_datapath(index = NULL, verbose = TRUE)

gt3x_filename(index = NULL, zipped = FALSE)
}
\arguments{
\item{index}{Integer. The index of a sample file to retrieve.
If NULL (default) the path to the directory
including the sample files will be returned.}

\item{verbose}{print diagnostic messages}

\item{zipped}{do the files have a \code{.zip} extension}
}
\value{
Character vector of files
}
\description{
Path to read.gt3x package sample data
}
\examples{
\dontrun{
dir <- gt3x_datapath()
gt3x_filename <- gt3x_datapath(1)
}

testthat::expect_error(gt3x_filename(100))
testthat::expect_error(gt3x_filename(0))
}
\seealso{
Other file manipulations: 
\code{\link{is_gt3x}()},
\code{\link{list_gt3x}()},
\code{\link{unzip.gt3x}()}
}
\concept{file manipulations}
