% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectDWD.R
\name{selectDWD}
\alias{selectDWD}
\title{Select data from the DWD CDC FTP Server}
\usage{
selectDWD(
  name = "",
  res = NA,
  var = NA,
  per = NA,
  expand = TRUE,
  id = findID(name, exactmatch = exactmatch, mindex = mindex, quiet = quiet, failempty =
    failempty),
  exactmatch = TRUE,
  mindex = metaIndex,
  failempty = TRUE,
  findex = fileIndex,
  current = FALSE,
  base = dwdbase,
  meta = FALSE,
  quiet = rdwdquiet(),
  ...
)
}
\arguments{
\item{name}{Char: station name(s) passed to \code{\link[=findID]{findID()}}, along with
\code{exactmatch}, \code{mindex} and \code{failempty}.
All 3 arguments are ignored if \code{id} is given.
DEFAULT: "" (all stations at \code{res/var/per})}

\item{res}{Char: temporal \strong{res}olution at \code{base}, e.g.
\verb{"hourly","daily","monthly"}.
See section 'Description' above and \code{\link{fileIndex}}.
Use \code{res=""} for matching options from all resolutions.
DEFAULT: NA for interactive selection}

\item{var}{Char: weather \strong{var}iable of interest, e.g.
\verb{"air_temperature", "cloudiness", "precipitation", "solar", "kl"}.
See section 'Description' above and \code{\link{fileIndex}}.
DEFAULT: NA for interactive selection}

\item{per}{Char: desired time \strong{per}iod, e.g.
"recent" (up to date records from the last 1.5 years) or
"historical" (long time series).
Can be abbreviated. To get both datasets, use \code{per="hr"}.
DEFAULT: NA for interactive selection}

\item{expand}{Logical: get all possible \code{res/var/per} combinations?
Set to FALSE if you want only the given combinations.
If FALSE, they cannot be NA or "".
DEFAULT: TRUE}

\item{id}{Char/Number: station ID with or without leading zeros, e.g. "00614" or 614.
Is internally converted to an integer.
Use NA (the default from \code{findID}) to get all data at \code{res/var/per}.
DEFAULT: \code{\link{findID}}\verb{(name, exaxtmatch, mindex, failempty)}}

\item{exactmatch}{Logical passed to \code{\link[=findID]{findID()}}: match \code{name}
with \code{\link{==}})? Else with \code{\link[=grepl]{grepl()}}. DEFAULT: TRUE}

\item{mindex}{Single object: Index with metadata passed to \code{\link[=findID]{findID()}}.
DEFAULT: \code{\link{metaIndex}}}

\item{failempty}{Fail if no matching station is found in \code{\link[=findID]{findID()}}?
Avoid downloading all files. DEFAULT: TRUE}

\item{findex}{Single object: Index used to select filename, as returned by
\code{\link[=createIndex]{createIndex()}}.To use a current / custom index, see \code{current} and
\url{https://bookdown.org/brry/rdwd/fileindex.html}.
DEFAULT: \code{\link{fileIndex}}}

\item{current}{Single logical when \code{res/var/per} is given: instead of
\code{findex}, use a list of the currently available files at
base/res/var/per? This will call \code{\link[=indexFTP]{indexFTP()}}, thus
requires availability of the \code{RCurl} package.
See \url{https://bookdown.org/brry/rdwd/fileindex.html}.
DEFAULT: FALSE}

\item{base}{Single char: main directory of DWD ftp server.
Must be the same \code{base} used to create \code{findex}.
DEFAULT: \code{\link{dwdbase}}}

\item{meta}{Logical: select Beschreibung file from \code{ismeta} entries in \code{findex}?
See \code{\link{metaIndex}} for a compilation of all Beschreibung files.
See the 'Examples' section for handling pdf and txt files.
DEFAULT: FALSE}

\item{quiet}{Suppress id length warnings? DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}

\item{\dots}{Further arguments passed to \code{\link[=indexFTP]{indexFTP()}} if \code{current=TRUE},
except folder and base.}
}
\value{
Character string with file path and name(s) in the format
"base/res/var/per/filename.zip"
}
\description{
Select data files for downloading with \code{\link[=dataDWD]{dataDWD()}}.\cr
The available \code{res/var/per} folders with datasets are listed
\href{https://bookdown.org/brry/rdwd/available-datasets.html}{online}.\cr
Set \verb{res="", var="", per=""} to avoid the default interactive selection.\cr
The arguments \code{name/id} and \code{res/var/per} can be vectors.
}
\examples{
# Give weather station name (must exist in metaIndex):
selectDWD("Potsdam", res="daily", var="kl", per="historical")

# all files for all stations matching "Koeln":
tail(selectDWD("Koeln", res="", var="", per="", exactmatch=FALSE)) # 686 files
findID("Koeln", FALSE)

\dontrun{ # Excluded from CRAN checks to save time

# selectDWD("Potsdam") # interactive selection of res/var/per

# directly give station ID:
selectDWD(id="00386", res="daily", var="kl", per="historical")
selectDWD(id=537, "", "", "", "") # 8 files

# period can be abbreviated:
selectDWD(id="5419", res="daily", var="kl", per="h")

# selectDWD is vectorizable!
# since version 1.5.28 (2022-05-12) outer product, not elementwise comparison:
selectDWD("Freiburg", res="daily", var="kl", per="rh")
selectDWD("Freiburg", res=c("daily","monthly"), var="kl", per="r")
selectDWD("Freiburg", res=c("daily","monthly"), var="kl", per="hr")
# get old behaviour (needed e.g. in nearbyStations):
ids <- c(3761,3761, 3603)
# all combinations:
selectDWD(id=ids, res="daily", var="kl", per=c("h","r","r")) # 4
# only given combinations:
selectDWD(id=ids, res="daily", var="kl", per=c("h","r","r"), expand=FALSE) # 3

# all files in all paths matching id:
head( selectDWD(id=c(1050, 386), res="",var="",per="") ) # 277 files
# all files in a given path (if ID is empty):
head(  selectDWD(id="", res="daily", var="kl", per="recent")   ) # 585 files

selectDWD(id=386, res="monthly", var="kl", per="h")

# Meta  data - Description and Beschreibung txt/pdf files.:
# manually select .txt (not pdf) files for automated opening with readDWD.
link <- selectDWD(res="monthly", var="kl", per="h", meta=TRUE) # omit ID/Name!
link
link2 <- grep("\\\\.txt$", link, value=TRUE)   ;   link2
m <- dataDWD(link2, dir=locdir())
head(m)
# 
# Open PDF files with your system's default Viewer:
dataDWD(link[1], dir=locdir())
}

}
\seealso{
\code{\link[=dataDWD]{dataDWD()}}, \code{\link{metaIndex}},
\href{https://bookdown.org/brry/rdwd/station-selection.html#by-name}{website station selection chapter}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Oct 2016, rewritten May 2022
}
\keyword{file}
