% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{update_rdhs_config}
\alias{update_rdhs_config}
\title{Update your current rdhs config}
\usage{
update_rdhs_config(
  password = FALSE,
  email = NULL,
  project = NULL,
  cache_path = NULL,
  config_path = NULL,
  global = NULL,
  verbose_download = NULL,
  verbose_setup = NULL,
  timeout = NULL,
  data_frame = NULL,
  project_choice = NULL
)
}
\arguments{
\item{password}{Logical for updating your password securely. Default = FALSE}

\item{email}{Character for email used to login to the DHS website.}

\item{project}{Character for the name of the DHS project from which
datasets should be downloaded.}

\item{cache_path}{Character for directory path where datasets and API calls
will be cached. If left bank, a suitable directory will be created within
your user cache directory for your operating system (permission granting).}

\item{config_path}{Character for where the config file should be saved.
For a global configuration, `config_path` must be '~/.rdhs.json'.
For a local configuration, `config_path` must be 'rdhs.json'.
If left bank, the config file will be stored within
your user cache directory for your operating system (permission granting).}

\item{global}{Logical for the config_path to be interpreted as a global
config path or a local one. Default = TRUE.}

\item{verbose_download}{Logical for dataset download progress bars to be
shown. Default = FALSE.}

\item{verbose_setup}{Logical for rdhs setup and messages to be printed.
Default = TRUE.}

\item{timeout}{Numeric for how long in seconds to wait for the DHS API to
respond. Default = 30.}

\item{data_frame}{Function with which to convert API calls into. If left
blank \code{data_frame} objects are returned. Must be passed as a
character. Examples could be:
\code{data.table::as.data.table}
\code{tibble::as.tibble}}

\item{project_choice}{Numeric for project choice. See \code{authenticate_dhs}
for more info.}
}
\description{
\code{update_rdhs_config} allows you to update elements of your
rdhs config, without having to set it completely via \code{set_rdhs_config}.
For each config element, provide the new changes required. To update your
password, set \code{password = TRUE} and you will be asked securely for your
new password.
}
