% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{get_available_datasets}
\alias{get_available_datasets}
\title{Get Available Datasets}
\usage{
get_available_datasets(clear_cache = FALSE)
}
\arguments{
\item{clear_cache}{Boolean detailing if you would like to clear the
cached available datasets first. The default is set to FALSE. This option
is available so that you can make sure your client fetches any new datasets
that you have recently been given access to.}
}
\value{
A \code{data.frame} with 14 variables that detail the surveys you can
  download, their url download links and the country, survey, year etc info
  for that link.
}
\description{
Details the datasets that your login credentials have access to
}
\details{
Searches the DHS website for all the datasets that you can download.
  The results of this function are cached in the client. If you have recently
  requested new datasets from the DHS website then you can specify to clear
  the cache first so that you get the new set of datasets available to you.
  This function is used by \code{\link{get_datasets}} and should thus be
  used with `clear_cache_first = TRUE` before using `get_datasets` if you
  have recently requested new datasets.
}
\examples{

\dontrun{
# grab the datasets
datasets <- get_available_datasets()

# and if we look at the last one it will be the model datasets from DHS
tail(datasets, 1)
}
}
