% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{ddi_frameUnit}
\alias{ddi_frameUnit}
\alias{ddi_unitType}
\title{frameUnit and its children}
\usage{
ddi_frameUnit(...)

ddi_unitType(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Provides information about the sampling frame unit. More information on
these elements, especially their allowed attributes, can be found in the
references.
}
\details{
\emph{Parent nodes}

\code{frameUnit} is contained in \code{sampleFrame}.

\emph{frameUnit specific child nodes}
\itemize{
\item \code{ddi_unitType()} describes the type of sampling frame unit. The attribute
"numberOfUnits" provides the number of units in the sampling frame.
}
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_txt]{ddi_txt()}}
}
}

\examples{
ddi_frameUnit()

# Functions that need to be wrapped in ddi_frameUnit()

ddi_unitType(numberOfUnits = 150000,
            "Primary listed owners of published phone numbers in the City of St. Paul")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/frameUnit.html}{frameUnit documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/unitType.html}{unitType documentation}
}
