% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fileTxt.R
\name{ddi_dimensns}
\alias{ddi_dimensns}
\alias{ddi_caseQnty}
\alias{ddi_logRecL}
\alias{ddi_recDimnsn}
\alias{ddi_recNumTot}
\alias{ddi_recPrCas}
\alias{ddi_varQnty}
\title{dimensns, recDimnsn and their child nodes}
\usage{
ddi_dimensns(...)

ddi_caseQnty(...)

ddi_logRecL(...)

ddi_recDimnsn(...)

ddi_recNumTot(...)

ddi_recPrCas(...)

ddi_varQnty(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Dimensions of the overall digital or physical file. More information on
these elements, especially their allowed attributes, can be found in the references.
}
\details{
\emph{Parent nodes}

\code{dimensns} is contained in \code{fileTxt}. \code{recDimensn} is contained in \code{recGrp}.

\emph{dimnsns and recDimnsn shared nodes}
\itemize{
\item \code{ddi_caseQnty()} is the number of cases, observations, or records.
\item \code{ddi_logRecL()} is the logical record length, i.e., number of characters of
data in the record.
\item \code{ddi_varQnty()} is the overall variable count.
}

\emph{dimnsns specific nodes}
\itemize{
\item \code{ddi_recNumTot()} is the overall record count in file. Particularly
helpful in instances such as files with multiple cards/decks or records per
case.
\item \code{ddi_recPrCas()} is the number of records per case in the file. This
element should be used for card-image data or other files in which there
are multiple records per case.
}
}
\examples{
ddi_dimensns()

ddi_recDimnsn()

# Functions that need to be wrapped in ddi_dimensns() or ddi_recDimnsn()

ddi_caseQnty("1011")

ddi_logRecL("27")

ddi_varQnty("27")

# Functions that need to be wrapped in ddi_dimensns

ddi_recNumTot("2400")

ddi_recPrCas("5")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/dimensns.html}{dimensns documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/caseQnty.html}{caseQnty documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/logRecL.html}{logRecL documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/recDimnsn.html}{recDimnsn documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/recNumTot.html}{recNumTot documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/recPrCas.html}{recPrCas documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/varQnty.html}{varQnty documentation}
}
