% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdbwdensity.R
\name{rdbwdensity}
\alias{rdbwdensity}
\title{Bandwidth Selection for Manipulation Testing using Local-Polynomial Density Estimation.}
\usage{
rdbwdensity(X, c = 0, p = 2, kernel = "", fitselect = "", vce = "")
}
\arguments{
\item{X}{Numeric vector or one dimensional matrix / data frame, the running variable.}

\item{c}{Numeric, the cutoff point, default being 0.}

\item{p}{Integer, the order of the local-polynomial used to construct the density
estimators, with default beign 2. It should be between 1 and 7.}

\item{kernel}{String, the kernel function, can be \code{triangular} (default),
\code{uniform} or \code{epanechnikov}.}

\item{fitselect}{String, either the \code{unrestricted} or the \code{restricted} model
(when set to the default, the unrestricted model will be used).}

\item{vce}{String, the standard error estimator, could be \code{plugin} (default) or
\code{jackknife}. When the bandwidths are not specified by the user, this argument will
also affect the bandwidth selection.}
}
\value{
\item{h}{Bandwidths for density discontinuity test, left and right to the cutoff, and asymptotic variance and bias.}
\item{N}{\code{full}: full sample size; \code{left}/\code{right}: sample size to the left/right of the cutoff.}
\item{opt}{Collects the options used, includes: \code{fitselect}, \code{kernel},
  \code{vce}, \code{c}, \code{p}. See options for \code{rdbwdensity}.}
\item{X_min}{Smallest observations to the left and right of the cutoff.}
\item{X_max}{Largest observations to the left and right of the cutoff.}
}
\description{
\code{rdbwdensity} implements several data-driven bandwidth selection methods
  useful to construct manipulation testing procedures using the local polynomial
  density estimators proposed in Cattaneo, Jansson and Ma (2017a).
}
\details{
Companion command: \code{\link{rddensity}} for density discontinuity (manipulation)
  testing. A detailed introduction to this command is given in Cattaneo, Jansson
  and Ma (2017a). A companion \code{Stata} package is described in Cattaneo,
  Jansson and Ma (2017b).
}
\examples{
x <- rnorm(1000)
example <- rdbwdensity(X = x, c = 1, vce="jackknife")
summary(example)
}
\references{
M. D. Cattaneo, M. Jansson and X. Ma. (2017a).  \href{http://www-personal.umich.edu/~cattaneo/papers/Cattaneo-Jansson-Ma_2017_LocPolDensity.pdf}{Simple Local Regression Distribution Estimators}. Working Paper, University of Michigan.

M. D. Cattaneo, M. Jansson and X. Ma. (2017b). \href{http://www-personal.umich.edu/~cattaneo/papers/Cattaneo-Jansson-Ma_2017_Stata.pdf}{rddensity: Manipulation Testing based on Density Discontinuity}. Working Paper, University of Michigan.
}
\seealso{
\code{\link{rddensity}}
}
\author{
Matias D. Cattaneo, University of Michigan.  \email{cattaneo@umich.edu}.

Michael Jansson, University of California, Berkeley.  \email{mjansson@econ.berkeley.edu}.

Xinwei Ma (maintainer), University of Michigan. \email{xinweima@umich.edu}.
}
