% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mrdi.R
\name{summary.mrdi}
\alias{summary.mrdi}
\title{Summarize the Multiple Imputation of Multivariate Regression Discontinuity}
\usage{
\method{summary}{mrdi}(object, level = 0.95, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{object}{An object of class \code{"mrdi"}, usually a result of a call to 
\code{\link{mrd_impute}} with \code{"front"} method.}

\item{level}{A numeric value between 0 and 1 specifying the confidence level for confidence intervals. The default is 0.95.}

\item{digits}{A non-negative integer specifying the number of digits to display.
The default is \code{max(3, getOption("digits") - 3)}.}

\item{...}{Additional arguments passed to \code{summary}.}
}
\value{
\code{summary.mrdi} returns a list which has the following components:
\item{coefficients}{A matrix containing estimates and confidence intervals (if applicable) 
for the complete model.}
\item{ht_coefficients}{A matrix containing estimates and confidence intervals (if applicable) 
for the heterogeneous treatment model.}
\item{t_coefficients}{A matrix containing estimates and confidence intervals (if applicable) 
for the treatment only model.}
}
\description{
\code{summary.mrdi} is a \code{summary} method for class \code{"mrdi"}.
It is based on \code{summary.RD} function in the "rdd" package.
}
\references{
Drew Dimmery (2016). rdd: Regression Discontinuity Estimation. R package
   version 0.57. https://CRAN.R-project.org/package=rdd
}
