% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.rd.R
\name{summary.rd}
\alias{summary.rd}
\title{Summarize the Regression Discontinuity}
\usage{
\method{summary}{rd}(object, level = 0.95, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{object}{An object of class \code{"rd"}, usually a result of a call to \code{\link{rd_est}}.}

\item{level}{Numerical value between 0 and 1. Confidence level for confidence intervals.}

\item{digits}{Number of digits to display.}

\item{...}{Additional arguments.}
}
\value{
\code{summary.rd} returns a list which has the following components:
\item{coefficients}{A matrix containing bandwidths, number of observations, estimates, 
  SEs, confidence intervals, z-values and p-values for each estimated bandwidth.}
}
\description{
\code{summary.rd} is a \code{summary} method for class \code{"rd"}
It is based on \code{\link[rdd]{summary.RD}} function in the \pkg{rdd} package.
}
