% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_converter.R
\name{id_converter}
\alias{id_converter}
\title{Get a PMID from a DOI, and vice versa.}
\usage{
id_converter(x, type = "doi", ...)
}
\arguments{
\item{x}{(character) One doi, pmid, or pmcid}

\item{type}{(character) one of doi, pmid, or pmcid}

\item{...}{Curl args passed on to \code{\link[httr]{GET}}.}
}
\description{
Get a PMID from a DOI, and vice versa.
}
\examples{
\dontrun{
# get a pmid/pmcid from a doi
id_converter("10.1038/ng.590")

# pmid to doi/pmcid
id_converter("20495566", "pmid")

# pmcid to doi/pmid
id_converter("PMC2883744", "pmcid")

# error, wrong type passed for id given
# id_converter("PMC2883744", "doi")
}
}
\references{
Uses the http://www.ncbi.nlm.nih.gov/pmc/tools/id-converter-api/
}

