% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmdata.R
\name{get_osm_city_boundary}
\alias{get_osm_city_boundary}
\title{Get the city boundary from OpenStreetMap}
\usage{
get_osm_city_boundary(
  bb,
  city_name,
  crs = NULL,
  multiple = FALSE,
  force_download = FALSE
)
}
\arguments{
\item{bb}{Bounding box of class \code{bbox}}

\item{city_name}{A case-sensitive character vector of length 1 with the name
of the city}

\item{crs}{Coordinate reference system as EPSG code}

\item{multiple}{A logical indicating if multiple city boundaries should be
returned. By default, only the first one is returned.}

\item{force_download}{Download data even if cached data is available}
}
\value{
An object of class \code{\link[sf:sfc]{sf::sfc_POLYGON}} or \code{\link[sf:sfc]{sf::sfc_MULTIPOLYGON}}
with the city boundary
}
\description{
This function retrieves the city boundary from OpenStreetMap based on a
bounding box with the OSM tags "place:city" and "boundary:administrative".
The result is filtered by the city name.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bb <- get_osm_bb("Bucharest")
crs <- get_utm_zone(bb)
get_osm_city_boundary(bb = bb, city_name = "Bucharest", crs = crs)
\dontshow{\}) # examplesIf}
}
