% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/near_repeat_eval.R
\name{near_repeat_eval}
\alias{near_repeat_eval}
\title{Identification of Optimal Time and Distance Parameters for Near Repeat Analysis}
\usage{
near_repeat_eval(data, epsg, tz = NULL)
}
\arguments{
\item{data}{Data frame of crime or RMS data. See provided Chicago Data Portal
example for reference}

\item{epsg}{The EPSG Geodetic Parameter code for the area being considered.
The EPSG code is used for identifying projections and performing coordinate
transformations. If needed, the EPSG for an area can be found at
\url{https://spatialreference.org}.}

\item{tz}{Time zone for which the area being examined. By default this value
is assigned as the same time zone of the system. For more information
about time zones within R, see \url{https://www.rdocumentation.org/packages/base/versions/3.6.1/topics/timezones}.}
}
\value{
Returns a data frame with one instance (row) of two fields (columns).
    The fields are: distance and time. The instance indicates the optimal
    near repeat parameters for each. Note that distance is given in meters
    and time is given as days.
}
\description{
This function performs an evaluation of given crime incidents to
    reccomend parameters for near repeat analysis. A series of time and distance
    parameters are tested using a full factorial design using the set of
    incident locations to determine the frequency of occurrence given each
    set of parameters. The results of the full factorial assessment are then
    modeled through interpolation and the second derivative is calculated to
    determine the inflection point. The inflection point represents the
    change in frequency of detected incidents which near repeat. Determination
    of the inflection point is completed for both the time and distance domains.
}
\examples{
\dontshow{
data(crimes)
nr_dat <- head(subset(crimes, crimes$primary_type == "BURGLARY"), n = 100)
pars <- near_repeat_eval(data=nr_dat, tz="America/Chicago", epsg="32616")
}
\donttest{
data(crimes)
nr_dat <- subset(crimes, crimes$primary_type == "BURGLARY")
pars <- near_repeat_eval(data=nr_dat, tz="America/Chicago", epsg="32616")
pars
}
}
\author{
Jamie Spaulding, Keith Morris
}
\keyword{spatial}
