% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{pwSpCorr}
\alias{pwSpCorr}
\title{Power spectra estimate via correlation}
\usage{
pwSpCorr(corcmb, lmax = 20 * length(corcmb$u))
}
\arguments{
\item{corcmb}{An object of the class CMBCorrelation.}

\item{lmax}{A number of angular power spectra components to estimate}
}
\value{
A data frame which first column is 1-d grid of l values
from 0 to \code{lmax}. The second column is
estimated angular power spectra components on this grid.
}
\description{
This function provides an angular power spectra estimate
using the values of the sample correlations. The approach is based
on Lawson-Hanson algorithm for non-negative least squares.
}
\examples{

## Download the map first
# downloadCMBMap(foreground = "smica", nside = 1024)
# df <- CMBDataFrame("CMB_map_smica1024.fits")
# Corrf <- corrCMB(df, max.dist = 0.1, num.bins = 30,
# sample.size=10000)
# pw <- pwSpCorr(Corrf)

}
\references{
Formula (2.1) in Baran A., Terdik G. Power spectrum
estimation of spherical random fields based on covariances.
Annales Mathematicae et Informaticae 44 (2015) pp. 15–22.
}
