% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NestSearch.R
\name{nestSearch}
\alias{nestSearch}
\title{Finds the closest pixel center to a point}
\usage{
nestSearch(target, nside, index.only = FALSE)
}
\arguments{
\item{target}{A data.frame, matrix or vector of
Cartesian (x,y,z) coordinates for the target point. If
a data.frame is used then spherical coordinates can
be specified with row names theta and phi.}

\item{nside}{An integer, the target resolution at which the
resulting pixels are returned.}

\item{index.only}{A boolean indicating whether to return only the
pixel index (TRUE), or cartesian coordinates as well (FALSE).}
}
\value{
if \code{index.only = TRUE} then the output will be a HEALPix index.
If \code{index.only} FALSE then the output is the list containing the HEALPix index
and Cartesian coordinate vector of the HEALPix point closest to \code{target}
at resolution \code{nside}.
}
\description{
Finds the closest HEALPix pixel center to a given \code{target} point,
specified in Cartesian coordinates, using an efficient nested search
algorithm. HEALPix indices are all assumed to be in the "nested"
ordering scheme.
}
\examples{

## Find the closest HEALPix pixel center at resolution j=2 for
## the point (0.6,0.8,0)

point <- c(0.6,0.8,0)
j <- 2
cpoint <- nestSearch(point, nside = 2^j)

## Plot the closest pixel center in blue and the point (0.6,0.8,0) in red
displayPixels(j, j, plot.j=j, spix=c(cpoint$pix),
              size=5, incl.labels =FALSE)
rgl::plot3d(point[1], point[2], point[3],
            col="red", size = 5, add = TRUE)


## Repeat the above for 4 points in a data.frame
points <- data.frame(x = c(1,0,0,0.6),
                     y = c(0,1,0,0.8),
                     z = c(0,0,1,0))
points
j <- 2
cpoints <- nestSearch(points, nside = 2^j)

## Plot the closest pixel center in blue and the point (0.6,0.8,0) in red
displayPixels(j, j, plot.j=j, spix=c(cpoints$pix),
              size=5, incl.labels =FALSE)
rgl::plot3d(points[,1], points[,2], points[,3],
            col="red", size = 5, add = TRUE)

}
