% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_vignette.R
\name{add_vignette}
\alias{add_vignette}
\title{Create a vignette document}
\usage{
add_vignette(
  filename = NULL,
  title = NULL,
  open = TRUE,
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{filename}{a character of length 1

The name of the \code{.Rmd} file to be created. If \code{NULL} (default )the \code{.Rmd}
file will be named \code{pkg.Rmd} where \code{pkg} is your package name.}

\item{title}{a character of length 1

The title of the vignette. If \code{NULL} (default) the title will be
\verb{Introduction to pkg} (where \code{pkg} is your package name).}

\item{open}{a logical value

If \code{TRUE} (default) the file is opened in the editor.}

\item{overwrite}{a logical value

If this file is already present and \code{overwrite = TRUE}, it will be erased
and replaced. Default is \code{FALSE}.}

\item{quiet}{a logical value

If \code{TRUE} messages are deleted. Default is \code{FALSE}.}
}
\value{
None
}
\description{
This function adds a vignette in the folder \verb{vignettes/}. It also adds
dependencies \href{https://yihui.org/knitr/}{\code{knitr}} and
\href{https://rmarkdown.rstudio.com/}{\code{rmarkdown}} in the
field \code{Suggests} of the \code{DESCRIPTION} file (if not already present in
fields \code{Imports}).
}
\examples{
\dontrun{
## Default vignette ----
add_vignette()

## Custom vignette ----
add_vignette(filename = "get_started", title = "Get started")
}
}
\seealso{
Other create files: 
\code{\link{add_citation}()},
\code{\link{add_compendium}()},
\code{\link{add_description}()},
\code{\link{add_license}()},
\code{\link{add_makefile}()},
\code{\link{add_package_doc}()},
\code{\link{add_readme_rmd}()},
\code{\link{add_testthat}()}
}
\concept{create files}
