% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spp_taxonconcept.R
\name{spp_taxonconcept}
\alias{spp_taxonconcept}
\title{Get taxon concepts for a search term}
\usage{
spp_taxonconcept(
  query_taxon,
  taxonomy = "CITES",
  with_descendants = FALSE,
  language = NULL,
  updated_since = NULL,
  per_page = 500,
  pages = NULL,
  raw = FALSE,
  token = NULL,
  verbose = TRUE,
  pause = 1,
  ...
)
}
\arguments{
\item{query_taxon}{a character string containing the query (e.g. species).
Scientific taxa only (max 255 characters).}

\item{taxonomy}{filter taxon concepts by taxonomy, accepts either 'CITES' or
'CMS' as its value. Default sets to 'CITES'.}

\item{with_descendants}{a logical. Should the search by name be broadened to
include higher taxa?}

\item{language}{filter languages returned for common names. Value should be a
vector of character strings including one or more country codes (two-letters
country code
\href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}{ISO 3166-1 alpha-2}).
Default is set to \code{NULL}, showing all available languages.}

\item{updated_since}{a timestamp. Only entries updated after (and including)
this timestamp will be pulled.}

\item{per_page}{an integer that indicates how many objects are returned per
page for paginated responses. Default set to 500 which is the maximum.}

\item{pages}{a vector of integer that contains page numbers. Default is
set to \code{NULL}, i.e. all pages are accessed.}

\item{raw}{a logical. Should raw data be returned?}

\item{token}{a character string containing the authentification token, see
\url{https://api.speciesplus.net/documentation}. Default is set to
\code{NULL} and requires the environment variable \code{SPECIESPLUS_TOKEN} to be set
directly in \code{Renviron}. Alternatively, \code{set_token()} can be used to set
\code{SPECIESPLUS_TOKEN} for the current session.}

\item{verbose}{a logical. Should extra information be reported on progress?}

\item{pause}{a duration (in second) to suspend execution for (see
\code{\link[=Sys.sleep]{Sys.sleep()}}). This was added cause the web API returns a 404 error too many
requests in a short time interval.}

\item{...}{Further named parameters, see \code{\link[httr:GET]{httr::GET()}}.}
}
\value{
If \code{raw = TRUE}, then a object of class \code{spp_raw} is returned, which is
a list of lists. If \code{raw = FALSE}, then an object of class \code{spp_taxon} is
returned, it is a collection of seven data frames:
\enumerate{
\item \code{all_id}: general information for all entries, including non-active taxon
concepts,
\item \code{general}: includes general information for active taxon concepts,
\item \code{higher_taxa}: includes taxonomy information,
\item \code{accepted_names}: list of accepted names (only for synonyms),
\item \code{common_names}: list of common names (only for accepted names),
\item \code{synonyms}: list of synonyms (only for accepted names),
\item \code{cites_listing}: list of current CITES listings with annotations
(missing if \code{taxonomy == 'CMS'}).
}
}
\description{
Retrieve the taxon concept of a specific taxon (scientific name).
}
\examples{
\donttest{
res1 <- spp_taxonconcept(query_taxon = 'Loxodonta africana')
res2 <- spp_taxonconcept(query_taxon = 'Amazilia versicolor', raw = TRUE)
res3 <- spp_taxonconcept(query_taxon = '', taxonomy = 'CMS', pages = c(1, 3),
 language = 'EN', verbose = FALSE, config = httr::progress())
res4 <- spp_taxonconcept(query_taxon = '', per_page = 20, pages = 44)
}
}
\references{
\url{https://api.speciesplus.net/documentation/v1/taxon_concepts/index.html}
}
