% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-setmiss.R, R/op-cdo-setctomiss.R,
%   R/op-cdo-setmisstoc.R, R/op-cdo-setmisstodis.R, R/op-cdo-setmisstonn.R,
%   R/op-cdo-setmissval.R, R/op-cdo-setrtomiss.R, R/op-cdo-setvrange.R
\name{setmiss}
\alias{setmiss}
\alias{cdo_setctomiss}
\alias{cdo_setmisstoc}
\alias{cdo_setmisstodis}
\alias{cdo_setmisstonn}
\alias{cdo_setmissval}
\alias{cdo_setrtomiss}
\alias{cdo_setvrange}
\title{Set missing value}
\usage{
cdo_setctomiss(
  ifile,
  neighbors = NULL,
  newmiss = NULL,
  c = NULL,
  rmin = NULL,
  rmax = NULL,
  ofile = NULL
)

cdo_setmisstoc(
  ifile,
  neighbors = NULL,
  newmiss = NULL,
  c = NULL,
  rmin = NULL,
  rmax = NULL,
  ofile = NULL
)

cdo_setmisstodis(
  ifile,
  neighbors = NULL,
  newmiss = NULL,
  c = NULL,
  rmin = NULL,
  rmax = NULL,
  ofile = NULL
)

cdo_setmisstonn(
  ifile,
  neighbors = NULL,
  newmiss = NULL,
  c = NULL,
  rmin = NULL,
  rmax = NULL,
  ofile = NULL
)

cdo_setmissval(
  ifile,
  neighbors = NULL,
  newmiss = NULL,
  c = NULL,
  rmin = NULL,
  rmax = NULL,
  ofile = NULL
)

cdo_setrtomiss(
  ifile,
  neighbors = NULL,
  newmiss = NULL,
  c = NULL,
  rmin = NULL,
  rmax = NULL,
  ofile = NULL
)

cdo_setvrange(
  ifile,
  neighbors = NULL,
  newmiss = NULL,
  c = NULL,
  rmin = NULL,
  rmax = NULL,
  ofile = NULL
)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{neighbors}{INTEGER - Number of nearest neighbors}

\item{newmiss}{FLOAT - New missing value}

\item{c}{FLOAT - Constant}

\item{rmin}{FLOAT - Lower bound}

\item{rmax}{FLOAT - Upper bound}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operatos that don't return filenames return a character vector with the
string output.
}
\description{
This module sets part of a field to missing value or missing values to a constant value. Which part of the field is set depends on the chosen operator.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{setmissval    Set a new missing value
                       / newmiss   if i(t,x) EQ miss
              o(t,x) = 
                       \\\\ i(t,x)    if i(t,x) NE miss
setctomiss    Set constant to missing value
                       / miss   if i(t,x) EQ c
              o(t,x) = 
                       \\\\ i(t,x) if i(t,x) NE c
setmisstoc    Set missing value to constant
                       / c      if i(t,x) EQ miss
              o(t,x) = 
                       \\\\ i(t,x) if i(t,x) NE miss
setrtomiss    Set range to missing value
                       / miss   if i(t,x) GE rmin AND i(t,x) LE rmax
              o(t,x) = 
                       \\\\ i(t,x) if i(t,x) LT rmin OR  i(t,x) GT rmax
setvrange     Set valid range
                       / miss   if i(t,x) LT rmin OR  i(t,x) GT rmax
              o(t,x) = 
                       \\\\ i(t,x) if i(t,x) GE rmin AND i(t,x) LE rmax
setmisstonn   Set missing value to nearest neighbor
              Set all missing values to the nearest non missing value.
                       / i(t,y) if i(t,x) EQ miss AND i(t,y) NE miss
              o(t,x) = 
                       \\\\ i(t,x) if i(t,x) NE miss
setmisstodis  Set missing value to distance-weighted average
              Set all missing values to the distance-weighted average of the nearest non missing values.
              The default number of nearest neighbors is 4.
}\if{html}{\out{</div>}}
}
