/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.util.ArrayList;
import org.openscience.cdk.charges.Electronegativity;
import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.charges.GasteigerPEPEPartialCharges;
import org.openscience.cdk.charges.PiElectronegativity;
import org.openscience.cdk.charges.Polarizability;
import org.openscience.cdk.charges.StabilizationCharges;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.reaction.type.ElectronImpactNBEReaction;
import org.openscience.cdk.reaction.type.parameters.IParameterReact;
import org.openscience.cdk.reaction.type.parameters.SetReactionCenter;
import org.openscience.cdk.tools.StructureResonanceGenerator;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

@Deprecated
public class IonizationPotentialTool {
    public static double predictIP(IAtomContainer container, IAtom atom) throws CDKException {
        double value = 0.0;
        if (container.getConnectedLonePairsCount(atom) == 0) {
            return value;
        }
        if (IonizationPotentialTool.familyHalogen(atom)) {
            value = IonizationPotentialTool.getDTHalogenF(IonizationPotentialTool.getQSARs(container, atom));
        } else if (IonizationPotentialTool.familyOxygen(atom)) {
            value = IonizationPotentialTool.getDTOxygenF(IonizationPotentialTool.getQSARs(container, atom));
        } else if (IonizationPotentialTool.familyNitrogen(atom)) {
            value = IonizationPotentialTool.getDTNitrogenF(IonizationPotentialTool.getQSARs(container, atom));
        }
        return value;
    }

    public static double predictIP(IAtomContainer container, IBond bond) throws CDKException {
        double value = 0.0;
        if (bond.getOrder().equals((Object)IBond.Order.SINGLE)) {
            return value;
        }
        for (int i = 0; i < 2; ++i) {
            IAtom atom = bond.getAtom(i);
            if (IonizationPotentialTool.familyHalogen(atom)) {
                return value;
            }
            if (IonizationPotentialTool.familyOxygen(atom)) {
                return value;
            }
            if (!IonizationPotentialTool.familyNitrogen(atom)) continue;
            return value;
        }
        if (!IonizationPotentialTool.familyBond(container, bond)) {
            return value;
        }
        return IonizationPotentialTool.getDTBondF(IonizationPotentialTool.getQSARs(container, bond));
    }

    private static boolean familyHalogen(IAtom atom) {
        String symbol = atom.getSymbol();
        return symbol.equals("F") || symbol.equals("Cl") || symbol.equals("Br") || symbol.equals("I");
    }

    private static boolean familyOxygen(IAtom atom) {
        String symbol = atom.getSymbol();
        return symbol.equals("O") || symbol.equals("S") || symbol.equals("Se") || symbol.equals("Te");
    }

    private static boolean familyNitrogen(IAtom atom) {
        String symbol = atom.getSymbol();
        return symbol.equals("N") || symbol.equals("P") || symbol.equals("As") || symbol.equals("Sb");
    }

    private static boolean familyBond(IAtomContainer container, IBond bond) {
        ArrayList<String> normalAt = new ArrayList<String>();
        normalAt.add("C");
        normalAt.add("H");
        if (IonizationPotentialTool.getDoubleBondNumber(container) > 30) {
            return false;
        }
        StructureResonanceGenerator gRN = new StructureResonanceGenerator();
        IAtomContainer ac = gRN.getContainer(container, bond);
        if (ac == null) {
            return true;
        }
        if (IonizationPotentialTool.getDoubleBondNumber(ac) > 15) {
            return false;
        }
        for (IAtom atom : container.atoms()) {
            if (normalAt.contains(atom.getSymbol()) || !ac.contains(atom)) continue;
            return false;
        }
        return true;
    }

    private static int getDoubleBondNumber(IAtomContainer container) {
        int doubleNumber = 0;
        for (IBond bond : container.bonds()) {
            if (!bond.getOrder().equals((Object)IBond.Order.DOUBLE) && !bond.getOrder().equals((Object)IBond.Order.TRIPLE)) continue;
            ++doubleNumber;
        }
        return doubleNumber;
    }

    public static double[] getQSARs(IAtomContainer container, IAtom atom) throws CDKException {
        Electronegativity electronegativity = new Electronegativity();
        PiElectronegativity pielectronegativity = new PiElectronegativity();
        GasteigerMarsiliPartialCharges peoe = new GasteigerMarsiliPartialCharges();
        GasteigerPEPEPartialCharges pepe = new GasteigerPEPEPartialCharges();
        Polarizability pol = new Polarizability();
        StabilizationCharges stabil = new StabilizationCharges();
        StructureResonanceGenerator gRI = new StructureResonanceGenerator();
        IAtomContainer product = IonizationPotentialTool.initiateIonization(container, atom);
        double[] results = new double[8];
        results[0] = electronegativity.calculateSigmaElectronegativity(container, atom);
        results[1] = pielectronegativity.calculatePiElectronegativity(container, atom);
        try {
            peoe.assignGasteigerMarsiliSigmaPartialCharges(container, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        results[2] = atom.getCharge();
        for (int i = 0; i < container.getAtomCount(); ++i) {
            container.getAtom(i).setCharge(0.0);
        }
        try {
            pepe.assignGasteigerPiPartialCharges(container, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        results[3] = atom.getCharge();
        results[4] = pol.calculateGHEffectiveAtomPolarizability(container, atom, 100, true);
        int position = container.indexOf(atom);
        results[5] = product != null ? stabil.calculatePositive(product, product.getAtom(position)) : 0.0;
        IAtomContainer acR = gRI.getContainer(container, atom);
        if (acR != null) {
            results[6] = acR.getAtomCount();
            IRingSet ringSet = Cycles.sssr(container).toRingSet();
            RingSetManipulator.markAromaticRings(ringSet);
            int aromRingCount = 0;
            for (IAtomContainer ring : ringSet.atomContainers()) {
                if (!ring.getFlag(32)) continue;
                ++aromRingCount;
            }
            results[7] = aromRingCount;
        } else {
            results[6] = 0.0;
            results[7] = 0.0;
        }
        return results;
    }

    public static double[] getQSARs(IAtomContainer container, IBond bond) throws CDKException {
        Electronegativity electronegativity = new Electronegativity();
        PiElectronegativity pielectronegativity = new PiElectronegativity();
        GasteigerMarsiliPartialCharges peoe = new GasteigerMarsiliPartialCharges();
        GasteigerPEPEPartialCharges pepe = new GasteigerPEPEPartialCharges();
        Polarizability pol = new Polarizability();
        StabilizationCharges stabil = new StabilizationCharges();
        StructureResonanceGenerator gRI = new StructureResonanceGenerator();
        double[] results = new double[7];
        for (int ia = 0; ia < 2; ++ia) {
            IAtom atom = bond.getAtom(ia);
            IAtomContainer product = IonizationPotentialTool.initiateIonization(container, atom);
            results[0] = results[0] + electronegativity.calculateSigmaElectronegativity(container, atom);
            results[1] = results[1] + pielectronegativity.calculatePiElectronegativity(container, atom);
            try {
                peoe.assignGasteigerMarsiliSigmaPartialCharges(container, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            results[2] = results[2] + atom.getCharge();
            for (int i = 0; i < container.getAtomCount(); ++i) {
                container.getAtom(i).setCharge(0.0);
            }
            try {
                pepe.assignGasteigerPiPartialCharges(container, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            results[3] = results[3] + atom.getCharge();
            results[4] = results[4] + pol.calculateGHEffectiveAtomPolarizability(container, atom, 100, true);
            int position = container.indexOf(atom);
            results[5] = product != null ? results[5] + stabil.calculatePositive(product, product.getAtom(position)) : results[5] + 0.0;
            IAtomContainer acR = gRI.getContainer(container, atom);
            results[6] = acR != null ? results[6] + (double)acR.getAtomCount() : results[6] + 0.0;
        }
        for (int i = 0; i < results.length; ++i) {
            results[i] = results[i] / 2.0;
        }
        return results;
    }

    private static double getDTHalogenF(double[] resultsH) {
        double result = 0.0;
        double SE = resultsH[0];
        double PSC = resultsH[2];
        double PIC = resultsH[3];
        double ETP = resultsH[4];
        double SPC = resultsH[5];
        double COUNTR = resultsH[6];
        double COUNTAr = resultsH[7];
        result = 0.272 * SE + 13.5814 * PSC + -4.4765 * PIC + -0.4937 * ETP + 0.0095 * SPC + -0.3706 * COUNTR + 0.5172 * COUNTAr + 12.4183;
        return result;
    }

    private static double getDTOxygenF(double[] resultsH) {
        double result = 0.0;
        double SE = resultsH[0];
        double PE = resultsH[1];
        double PSC = resultsH[2];
        double PIC = resultsH[3];
        double ETP = resultsH[4];
        double SPC = resultsH[5];
        double COUNTR = resultsH[6];
        result = -0.0118 * SE - 0.1859 * PE - 0.0752 * PSC - 8.1697 * PIC - 0.2278 * ETP - 0.0041 * SPC + 0.0175 * COUNTR + 11.4835;
        return result;
    }

    private static double getDTNitrogenF(double[] resultsH) {
        double result = 0.0;
        double SE = resultsH[0];
        double PE = resultsH[1];
        double PSC = resultsH[2];
        double PIC = resultsH[3];
        double ETP = resultsH[4];
        double SPC = resultsH[5];
        double COUNTR = resultsH[6];
        result = 0.4634 * SE + 0.0201 * PE + 1.1897 * PSC - 3.598 * PIC - 0.2726 * ETP + 6.0E-4 * SPC - 0.0527 * COUNTR + 6.5419;
        return result;
    }

    private static double getDTBondF(double[] resultsH) {
        double result = 0.0;
        double SE = resultsH[0];
        double PE = resultsH[1];
        double PSC = resultsH[2];
        double PIC = resultsH[3];
        double ETP = resultsH[4];
        double COUNTR = resultsH[6];
        result = 0.1691 * SE + 1.1536 * PE + -6.3049 * PSC + -15.2638 * PIC + -0.2456 * ETP + -0.0139 * COUNTR + 2.114;
        return result;
    }

    private static IAtomContainer initiateIonization(IAtomContainer container, IAtom atom) throws CDKException {
        ElectronImpactNBEReaction reactionNBE = new ElectronImpactNBEReaction();
        IAtomContainerSet setOfReactants = container.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        setOfReactants.addAtomContainer(container);
        atom.setFlag(1024, true);
        ArrayList<IParameterReact> paramList = new ArrayList<IParameterReact>();
        SetReactionCenter param = new SetReactionCenter();
        param.setParameter(Boolean.TRUE);
        paramList.add(param);
        reactionNBE.setParameterList(paramList);
        IReactionSet setOfReactions = reactionNBE.initiate(setOfReactants, null);
        atom.setFlag(1024, false);
        if (setOfReactions != null && setOfReactions.getReactionCount() == 1 && setOfReactions.getReaction(0).getProducts().getAtomContainerCount() == 1) {
            return setOfReactions.getReaction(0).getProducts().getAtomContainer(0);
        }
        return null;
    }
}

