/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.io.formats.AbstractResourceFormat;
import org.openscience.cdk.io.formats.IChemFormat;
import org.openscience.cdk.io.formats.IResourceFormat;

@TestClass(value="org.openscience.cdk.io.formats.XYZFormatTest")
public class XYZFormat
extends AbstractResourceFormat
implements IChemFormat {
    private static IResourceFormat myself = null;

    @TestMethod(value="testResourceFormatSet")
    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new XYZFormat();
        }
        return myself;
    }

    @TestMethod(value="testGetFormatName")
    public String getFormatName() {
        return "XYZ";
    }

    @TestMethod(value="testGetMIMEType")
    public String getMIMEType() {
        return "chemical/x-xyz";
    }

    @TestMethod(value="testGetPreferredNameExtension")
    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    @TestMethod(value="testGetNameExtensions")
    public String[] getNameExtensions() {
        return new String[]{"xyz"};
    }

    @TestMethod(value="testGetReaderClassName")
    public String getReaderClassName() {
        return "org.openscience.cdk.io.XYZReader";
    }

    @TestMethod(value="testGetWriterClassName")
    public String getWriterClassName() {
        return "org.openscience.cdk.io.XYZWriter";
    }

    @TestMethod(value="testIsXMLBased")
    public boolean isXMLBased() {
        return false;
    }

    @TestMethod(value="testGetSupportedDataFeatures")
    public int getSupportedDataFeatures() {
        return this.getRequiredDataFeatures() | 0x10;
    }

    @TestMethod(value="testGetRequiredDataFeatures")
    public int getRequiredDataFeatures() {
        return 10;
    }
}

