/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SimpleChemFormatMatcher;

@TestClass(value="org.openscience.cdk.io.formats.PDBFormatTest")
public class PDBFormat
extends SimpleChemFormatMatcher
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    @TestMethod(value="testResourceFormatSet")
    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new PDBFormat();
        }
        return myself;
    }

    @TestMethod(value="testGetFormatName")
    public String getFormatName() {
        return "Protein Brookhave Database (PDB)";
    }

    @TestMethod(value="testGetMIMEType")
    public String getMIMEType() {
        return "chemical/x-pdb";
    }

    @TestMethod(value="testGetPreferredNameExtension")
    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    @TestMethod(value="testGetNameExtensions")
    public String[] getNameExtensions() {
        return new String[]{"pdb", "ent"};
    }

    @TestMethod(value="testGetReaderClassName")
    public String getReaderClassName() {
        return "org.openscience.cdk.io.PDBReader";
    }

    @TestMethod(value="testGetWriterClassName")
    public String getWriterClassName() {
        return "org.openscience.cdk.io.PDBWriter";
    }

    @TestMethod(value="testMatches")
    public boolean matches(int lineNumber, String line) {
        return line.startsWith("HEADER") || line.startsWith("HETATM ") || line.startsWith("ATOM  ");
    }

    @TestMethod(value="testIsXMLBased")
    public boolean isXMLBased() {
        return false;
    }

    @TestMethod(value="testGetSupportedDataFeatures")
    public int getSupportedDataFeatures() {
        return 4 | this.getRequiredDataFeatures();
    }

    @TestMethod(value="testGetRequiredDataFeatures")
    public int getRequiredDataFeatures() {
        return 10;
    }
}

