/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.config.IAtomTypeConfigurator;
import org.openscience.cdk.config.ImmutableAtomType;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.NoSuchAtomTypeException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class AtomTypeFactory {
    public static final String ATOMTYPE_ID_STRUCTGEN = "structgen";
    public static final String ATOMTYPE_ID_MODELING = "modeling";
    public static final String ATOMTYPE_ID_JMOL = "jmol";
    private static final String TXT_EXTENSION = "txt";
    private static final String XML_EXTENSION = "xml";
    private static final String OWL_EXTENSION = "owl";
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(AtomTypeFactory.class);
    private static Map<String, AtomTypeFactory> tables = null;
    private Map<String, IAtomType> atomTypes = new HashMap<String, IAtomType>(100);

    private AtomTypeFactory(String configFile, IChemObjectBuilder builder) {
        this.readConfiguration(configFile, builder);
    }

    private AtomTypeFactory(InputStream ins, String format, IChemObjectBuilder builder) {
        this.readConfiguration(ins, format, builder);
    }

    public static AtomTypeFactory getInstance(InputStream ins, String format, IChemObjectBuilder builder) {
        return new AtomTypeFactory(ins, format, builder);
    }

    public static AtomTypeFactory getInstance(IChemObjectBuilder builder) {
        return AtomTypeFactory.getInstance("org/openscience/cdk/config/data/structgen_atomtypes.xml", builder);
    }

    public static AtomTypeFactory getInstance(String configFile, IChemObjectBuilder builder) {
        if (tables == null) {
            tables = new Hashtable<String, AtomTypeFactory>();
        }
        if (!tables.containsKey(configFile)) {
            tables.put(configFile, new AtomTypeFactory(configFile, builder));
        }
        return tables.get(configFile);
    }

    private void readConfiguration(String fileName, IChemObjectBuilder builder) {
        logger.info("Reading config file from ", fileName);
        InputStream ins = this.getClass().getClassLoader().getResourceAsStream(fileName);
        if (ins == null) {
            File file = new File(fileName);
            if (file.exists()) {
                logger.debug("configFile is a File");
                try {
                    ins = new FileInputStream(file);
                }
                catch (Exception exception) {
                    logger.error(exception.getMessage());
                    logger.debug(exception);
                }
            } else {
                logger.error("no stream and no file");
            }
        }
        String format = XML_EXTENSION;
        if (fileName.endsWith(TXT_EXTENSION)) {
            format = TXT_EXTENSION;
        } else if (fileName.endsWith(XML_EXTENSION)) {
            format = XML_EXTENSION;
        } else if (fileName.endsWith(OWL_EXTENSION)) {
            format = OWL_EXTENSION;
        }
        this.readConfiguration(ins, format, builder);
    }

    private IAtomTypeConfigurator constructConfigurator(String format) {
        try {
            if (format.equals(TXT_EXTENSION)) {
                return (IAtomTypeConfigurator)this.getClass().getClassLoader().loadClass("org.openscience.cdk.config.TXTBasedAtomTypeConfigurator").newInstance();
            }
            if (format.equals(XML_EXTENSION)) {
                return (IAtomTypeConfigurator)this.getClass().getClassLoader().loadClass("org.openscience.cdk.config.CDKBasedAtomTypeConfigurator").newInstance();
            }
            if (format.equals(OWL_EXTENSION)) {
                return (IAtomTypeConfigurator)this.getClass().getClassLoader().loadClass("org.openscience.cdk.config.OWLBasedAtomTypeConfigurator").newInstance();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException exc) {
            logger.error("Could not get instance of AtomTypeConfigurator for format ", format);
            logger.debug(exc);
        }
        return null;
    }

    private void readConfiguration(InputStream ins, String format, IChemObjectBuilder builder) {
        IAtomTypeConfigurator atc = this.constructConfigurator(format);
        if (atc != null) {
            atc.setInputStream(ins);
            try {
                List<IAtomType> readAtomTypes = atc.readAtomTypes(builder);
                for (IAtomType type : readAtomTypes) {
                    this.atomTypes.put(type.getAtomTypeName(), new ImmutableAtomType(type));
                }
            }
            catch (Exception exc) {
                logger.error("Could not read AtomType's from file due to: ", exc.getMessage());
                logger.debug(exc);
            }
        } else {
            logger.debug("AtomTypeConfigurator was null!");
            this.atomTypes = new HashMap<String, IAtomType>();
        }
    }

    public int getSize() {
        return this.atomTypes.size();
    }

    public IAtomType getAtomType(String identifier) throws NoSuchAtomTypeException {
        IAtomType type = this.atomTypes.get(identifier);
        if (type != null) {
            return type;
        }
        throw new NoSuchAtomTypeException("The AtomType " + identifier + " could not be found");
    }

    public IAtomType[] getAtomTypes(String symbol) {
        logger.debug("Request for atomtype for symbol ", symbol);
        ArrayList<IAtomType> atomList = new ArrayList<IAtomType>();
        for (IAtomType atomType : this.atomTypes.values()) {
            if (!atomType.getSymbol().equals(symbol)) continue;
            atomList.add(atomType);
        }
        IAtomType[] atomTypes = atomList.toArray(new IAtomType[atomList.size()]);
        if (atomTypes.length > 0) {
            logger.debug("Atomtype for symbol ", symbol, " has this number of types: " + atomTypes.length);
        } else {
            logger.debug("No atomtype for symbol ", symbol);
        }
        return atomTypes;
    }

    public IAtomType[] getAllAtomTypes() {
        logger.debug("Returning list of size: ", this.getSize());
        return this.atomTypes.values().toArray(new IAtomType[this.atomTypes.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IAtom configure(IAtom atom) throws CDKException {
        if (atom instanceof IPseudoAtom) {
            return atom;
        }
        try {
            IAtomType atomType;
            String atomTypeName = atom.getAtomTypeName();
            if (atomTypeName == null || atomTypeName.length() == 0) {
                logger.debug("Using atom symbol because atom type name is empty...");
                IAtomType[] types = this.getAtomTypes(atom.getSymbol());
                if (types.length <= 0) {
                    String message = "Could not configure atom with unknown ID: " + atom.toString() + " + (id=" + atom.getAtomTypeName() + ")";
                    logger.warn(message);
                    throw new CDKException(message);
                }
                logger.warn("Taking first atom type, but other may exist");
                atomType = types[0];
            } else {
                atomType = this.getAtomType(atom.getAtomTypeName());
            }
            logger.debug("Configuring with atomtype: ", atomType);
            atom.setSymbol(atomType.getSymbol());
            atom.setMaxBondOrder(atomType.getMaxBondOrder());
            atom.setBondOrderSum(atomType.getBondOrderSum());
            atom.setCovalentRadius(atomType.getCovalentRadius());
            atom.setHybridization(atomType.getHybridization());
            Object color = atomType.getProperty("org.openscience.cdk.renderer.color");
            if (color != null) {
                atom.setProperty("org.openscience.cdk.renderer.color", color);
            }
            atom.setAtomicNumber(atomType.getAtomicNumber());
            atom.setExactMass(atomType.getExactMass());
        }
        catch (Exception exception) {
            logger.warn("Could not configure atom with unknown ID: ", atom, " + (id=", atom.getAtomTypeName(), ")");
            logger.debug(exception);
            throw new CDKException(exception.toString(), exception);
        }
        logger.debug("Configured: ", atom);
        return atom;
    }
}

