/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IPseudoAtom;

public class PseudoAtom
extends Atom
implements Serializable,
Cloneable,
IPseudoAtom {
    private static final long serialVersionUID = 1L;
    private String label;

    public PseudoAtom() {
        this("*");
    }

    public PseudoAtom(String label) {
        super("R");
        this.label = label;
        this.fractionalPoint3d = null;
        this.point3d = null;
        this.point2d = null;
        this.stereoParity = 0;
    }

    public PseudoAtom(IElement element) {
        super(element);
        if (element instanceof IPseudoAtom) {
            this.label = ((IPseudoAtom)element).getLabel();
        } else {
            this.symbol = "R";
            this.label = element.getSymbol();
        }
    }

    public PseudoAtom(String label, Point3d point3d) {
        this(label);
        this.point3d = point3d;
    }

    public PseudoAtom(String label, Point2d point2d) {
        this(label);
        this.point2d = point2d;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.notifyChanged();
    }

    public void setStereoParity(Integer stereoParity) {
    }

    public String toString() {
        StringBuffer description = new StringBuffer();
        description.append("PseudoAtom(");
        description.append(this.hashCode());
        if (this.getLabel() != null) {
            description.append(", ").append(this.getLabel());
        }
        description.append(", ").append(super.toString());
        description.append(')');
        return description.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

