/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.AtomCountDescriptorTest")
public class AtomCountDescriptor
implements IMolecularDescriptor {
    private String elementName = "*";

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#atomCount", this.getClass().getName(), "$Id: 00cf7164a7d9466a6ba750a39036418b7fbebfd8 $", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("AtomCount only expects one parameter");
        }
        if (!(params[0] instanceof String)) {
            throw new CDKException("The parameter must be of type String");
        }
        this.elementName = (String)params[0];
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] params = new Object[]{this.elementName};
        return params;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        String name = "n";
        name = this.elementName.equals("*") ? "nAtom" : name + this.elementName;
        return new String[]{name};
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer container) {
        int atomCount = 0;
        if (container == null) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), new CDKException("The supplied AtomContainer was NULL"));
        }
        if (container.getAtomCount() == 0) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), new CDKException("The supplied AtomContainer did not have any atoms"));
        }
        if (this.elementName.equals("*")) {
            for (int i = 0; i < container.getAtomCount(); ++i) {
                Integer hcount = container.getAtom(i).getImplicitHydrogenCount();
                if (hcount == CDKConstants.UNSET) continue;
                atomCount += hcount.intValue();
            }
            atomCount += container.getAtomCount();
        } else if (this.elementName.equals("H")) {
            for (int i = 0; i < container.getAtomCount(); ++i) {
                if (container.getAtom(i).getSymbol().equals(this.elementName)) {
                    ++atomCount;
                    continue;
                }
                Integer hcount = container.getAtom(i).getImplicitHydrogenCount();
                if (hcount == CDKConstants.UNSET) continue;
                atomCount += hcount.intValue();
            }
        } else {
            for (int i = 0; i < container.getAtomCount(); ++i) {
                if (!container.getAtom(i).getSymbol().equals(this.elementName)) continue;
                ++atomCount;
            }
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(atomCount), this.getDescriptorNames());
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] params = new String[]{"elementName"};
        return params;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return "";
    }
}

