/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.xmlcml.euclid.EuclidConstants;

public class IntRange
implements EuclidConstants {
    protected int maxval;
    protected int minval;

    public IntRange() {
        this.minval = Integer.MAX_VALUE;
        this.maxval = Integer.MIN_VALUE;
    }

    public IntRange(int minv, int maxv) {
        this.maxval = maxv;
        this.minval = minv;
        if (this.minval > this.maxval) {
            this.minval = Integer.MAX_VALUE;
            this.maxval = Integer.MIN_VALUE;
        }
    }

    public IntRange(IntRange r) {
        this.minval = r.minval;
        this.maxval = r.maxval;
    }

    public boolean isValid() {
        return this.minval <= this.maxval;
    }

    public boolean isEqualTo(IntRange r) {
        return r != null && this.minval == r.minval && this.maxval == r.maxval && this.minval <= this.maxval;
    }

    public IntRange plus(IntRange r2) {
        if (!this.isValid()) {
            if (r2 == null || !r2.isValid()) {
                return new IntRange();
            }
            return new IntRange(r2);
        }
        IntRange temp = new IntRange();
        temp = new IntRange(Math.min(this.minval, r2.minval), Math.max(this.maxval, r2.maxval));
        return temp;
    }

    public IntRange intersectionWith(IntRange r2) {
        if (!this.isValid() || r2 == null || !r2.isValid()) {
            return new IntRange();
        }
        int minv = Math.max(this.minval, r2.minval);
        int maxv = Math.min(this.maxval, r2.maxval);
        return new IntRange(minv, maxv);
    }

    public int getMin() {
        return this.minval;
    }

    public int getMax() {
        return this.maxval;
    }

    public int getRange() {
        if (!this.isValid()) {
            return Integer.MIN_VALUE;
        }
        return this.maxval - this.minval;
    }

    public boolean includes(IntRange r2) {
        return r2 != null && r2.isValid() && this.includes(r2.getMin()) && this.includes(r2.getMax());
    }

    public boolean includes(int f) {
        return f >= this.minval && f <= this.maxval;
    }

    public boolean contains(int f) {
        return this.includes(f);
    }

    public void add(int x) {
        this.maxval = Math.max(this.maxval, x);
        this.minval = Math.min(this.minval, x);
    }

    public String toString() {
        return this.minval > this.maxval ? "NULL" : "(" + this.minval + "," + this.maxval + ")";
    }
}

