/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;

@TestClass(value="org.openscience.cdk.io.MDLV2000WriterTest")
public class MDLV2000Writer
extends DefaultChemObjectWriter {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLV2000Writer.class);
    private BooleanIOSetting forceWriteAs2DCoords;
    private BooleanIOSetting writeAromaticBondTypes;
    private BufferedWriter writer;

    public MDLV2000Writer(Writer out) {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        this.initIOSettings();
    }

    public MDLV2000Writer(OutputStream output) {
        this(new OutputStreamWriter(output));
    }

    public MDLV2000Writer() {
        this(new StringWriter());
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return MDLFormat.getInstance();
    }

    @Override
    public void setWriter(Writer out) throws CDKException {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    @Override
    public void setWriter(OutputStream output) throws CDKException {
        this.setWriter(new OutputStreamWriter(output));
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.writer.close();
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (IAtomContainer.class.equals(interfaces[i])) {
                return true;
            }
            if (IChemFile.class.equals(interfaces[i])) {
                return true;
            }
            if (!IChemModel.class.equals(interfaces[i])) continue;
            return true;
        }
        Class superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public void write(IChemObject object) throws CDKException {
        this.customizeJob();
        try {
            if (object instanceof IChemFile) {
                this.writeChemFile((IChemFile)object);
                return;
            }
            if (object instanceof IChemModel) {
                IChemFile file = object.getBuilder().newInstance(IChemFile.class, new Object[0]);
                IChemSequence sequence = object.getBuilder().newInstance(IChemSequence.class, new Object[0]);
                sequence.addChemModel((IChemModel)object);
                file.addChemSequence(sequence);
                this.writeChemFile(file);
                return;
            }
            if (object instanceof IAtomContainer) {
                this.writeMolecule((IAtomContainer)object);
                return;
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            logger.debug(ex);
            throw new CDKException("Exception while writing MDL file: " + ex.getMessage(), ex);
        }
        throw new CDKException("Only supported is writing of IChemFile, IChemModel, and IAtomContainer objects.");
    }

    private void writeChemFile(IChemFile file) throws Exception {
        IAtomContainer bigPile = file.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (IAtomContainer container : ChemFileManipulator.getAllAtomContainers(file)) {
            bigPile.add(container);
            if (container.getProperty("cdk:Title") != null) {
                if (bigPile.getProperty("cdk:Title") != null) {
                    bigPile.setProperty("cdk:Title", bigPile.getProperty("cdk:Title") + "; " + container.getProperty("cdk:Title"));
                } else {
                    bigPile.setProperty("cdk:Title", container.getProperty("cdk:Title"));
                }
            }
            if (container.getProperty("cdk:Remark") == null) continue;
            if (bigPile.getProperty("cdk:Remark") != null) {
                bigPile.setProperty("cdk:Remark", bigPile.getProperty("cdk:Remark") + "; " + container.getProperty("cdk:Remark"));
                continue;
            }
            bigPile.setProperty("cdk:Remark", container.getProperty("cdk:Remark"));
        }
        this.writeMolecule(bigPile);
    }

    public void writeMolecule(IAtomContainer container) throws Exception {
        int i;
        String line = "";
        ArrayList<Integer> rgroupList = null;
        String title = (String)container.getProperty("cdk:Title");
        if (title == null) {
            title = "";
        }
        if (title.length() > 80) {
            title = title.substring(0, 80);
        }
        this.writer.write(title);
        this.writer.newLine();
        this.writer.write("  CDK     ");
        this.writer.write(new SimpleDateFormat("MMddyyHHmm").format(System.currentTimeMillis()));
        this.writer.newLine();
        String comment = (String)container.getProperty("cdk:Remark");
        if (comment == null) {
            comment = "";
        }
        if (comment.length() > 80) {
            comment = comment.substring(0, 80);
        }
        this.writer.write(comment);
        this.writer.newLine();
        line = line + MDLV2000Writer.formatMDLInt(container.getAtomCount(), 3);
        line = line + MDLV2000Writer.formatMDLInt(container.getBondCount(), 3);
        line = line + "  0  0  0  0  0  0  0  0999 V2000";
        this.writer.write(line);
        this.writer.newLine();
        for (int f = 0; f < container.getAtomCount(); ++f) {
            IAtom atom = container.getAtom(f);
            line = "";
            if (atom.getPoint3d() != null && !this.forceWriteAs2DCoords.isSet()) {
                line = line + MDLV2000Writer.formatMDLFloat((float)atom.getPoint3d().x);
                line = line + MDLV2000Writer.formatMDLFloat((float)atom.getPoint3d().y);
                line = line + MDLV2000Writer.formatMDLFloat((float)atom.getPoint3d().z) + " ";
            } else if (atom.getPoint2d() != null) {
                line = line + MDLV2000Writer.formatMDLFloat((float)atom.getPoint2d().x);
                line = line + MDLV2000Writer.formatMDLFloat((float)atom.getPoint2d().y);
                line = line + "    0.0000 ";
            } else {
                line = line + MDLV2000Writer.formatMDLFloat(0.0f);
                line = line + MDLV2000Writer.formatMDLFloat(0.0f);
                line = line + MDLV2000Writer.formatMDLFloat(0.0f) + " ";
            }
            if (container.getAtom(f) instanceof IPseudoAtom) {
                IPseudoAtom pseudoAtom = (IPseudoAtom)container.getAtom(f);
                if (pseudoAtom.getSymbol().equals("R") && pseudoAtom.getLabel().length() > 1) {
                    line = line + "R# ";
                    if (rgroupList == null) {
                        rgroupList = new ArrayList<Integer>();
                    }
                    Integer rGroupNumber = new Integer(pseudoAtom.getLabel().substring(1));
                    rgroupList.add(f + 1);
                    rgroupList.add(rGroupNumber);
                } else {
                    line = line + MDLV2000Writer.formatMDLString(((IPseudoAtom)container.getAtom(f)).getLabel(), 3);
                }
            } else {
                line = line + MDLV2000Writer.formatMDLString(container.getAtom(f).getSymbol(), 3);
            }
            line = line + " 0  0  0  0  0";
            line = atom.getValency() == (Integer)CDKConstants.UNSET ? line + MDLV2000Writer.formatMDLInt(0, 3) : (atom.getValency() == 0 ? line + MDLV2000Writer.formatMDLInt(15, 3) : line + MDLV2000Writer.formatMDLInt(atom.getValency(), 3));
            line = line + "  0  0  0";
            if (container.getAtom(f).getProperty("cdk:AtomAtomMapping") != null) {
                int value = (Integer)container.getAtom(f).getProperty("cdk:AtomAtomMapping");
                line = line + MDLV2000Writer.formatMDLInt(value, 3);
            } else {
                line = line + MDLV2000Writer.formatMDLInt(0, 3);
            }
            line = line + "  0  0";
            this.writer.write(line);
            this.writer.newLine();
        }
        for (IBond bond : container.bonds()) {
            int bondType;
            if (bond.getAtomCount() != 2) {
                logger.warn("Skipping bond with more/less than two atoms: " + bond);
                continue;
            }
            if (bond.getStereo() == IBond.Stereo.UP_INVERTED || bond.getStereo() == IBond.Stereo.DOWN_INVERTED || bond.getStereo() == IBond.Stereo.UP_OR_DOWN_INVERTED) {
                line = MDLV2000Writer.formatMDLInt(container.getAtomNumber(bond.getAtom(1)) + 1, 3);
                line = line + MDLV2000Writer.formatMDLInt(container.getAtomNumber(bond.getAtom(0)) + 1, 3);
            } else {
                line = MDLV2000Writer.formatMDLInt(container.getAtomNumber(bond.getAtom(0)) + 1, 3);
                line = line + MDLV2000Writer.formatMDLInt(container.getAtomNumber(bond.getAtom(1)) + 1, 3);
            }
            if (this.writeAromaticBondTypes.isSet() && bond.getFlag(5)) {
                bondType = 4;
            } else {
                if (IBond.Order.QUADRUPLE == bond.getOrder()) {
                    throw new CDKException("MDL molfiles do not support quadruple bonds.");
                }
                bondType = bond.getOrder().ordinal() + 1;
            }
            line = line + MDLV2000Writer.formatMDLInt(bondType, 3);
            line = line + "  ";
            switch (bond.getStereo()) {
                case UP: {
                    line = line + "1";
                    break;
                }
                case UP_INVERTED: {
                    line = line + "1";
                    break;
                }
                case DOWN: {
                    line = line + "6";
                    break;
                }
                case DOWN_INVERTED: {
                    line = line + "6";
                    break;
                }
                case UP_OR_DOWN: {
                    line = line + "4";
                    break;
                }
                case UP_OR_DOWN_INVERTED: {
                    line = line + "4";
                    break;
                }
                case E_OR_Z: {
                    line = line + "3";
                    break;
                }
                default: {
                    line = line + "0";
                }
            }
            line = line + "  0  0  0 ";
            this.writer.write(line);
            this.writer.newLine();
        }
        for (i = 0; i < container.getAtomCount(); ++i) {
            IAtom atom = container.getAtom(i);
            if (atom.getProperty("cdk:Comment") == null || !(atom.getProperty("cdk:Comment") instanceof String) || ((String)atom.getProperty("cdk:Comment")).trim().equals("")) continue;
            this.writer.write("V  ");
            this.writer.write(MDLV2000Writer.formatMDLInt(i + 1, 3));
            this.writer.write(" ");
            this.writer.write((String)atom.getProperty("cdk:Comment"));
            this.writer.newLine();
        }
        for (i = 0; i < container.getAtomCount(); ++i) {
            IAtom atom = container.getAtom(i);
            Integer charge = atom.getFormalCharge();
            if (charge == null || charge == 0) continue;
            this.writer.write("M  CHG  1 ");
            this.writer.write(MDLV2000Writer.formatMDLInt(i + 1, 3));
            this.writer.write(" ");
            this.writer.write(MDLV2000Writer.formatMDLInt(charge, 3));
            this.writer.newLine();
        }
        for (i = 0; i < container.getAtomCount(); ++i) {
            Integer atomicMass;
            IAtom atom = container.getAtom(i);
            if (atom instanceof IPseudoAtom || (atomicMass = atom.getMassNumber()) == null) continue;
            int majorMass = IsotopeFactory.getInstance(atom.getBuilder()).getMajorIsotope(atom.getSymbol()).getMassNumber();
            if (atomicMass == majorMass) continue;
            this.writer.write("M  ISO  1 ");
            this.writer.write(MDLV2000Writer.formatMDLInt(i + 1, 3));
            this.writer.write(" ");
            this.writer.write(MDLV2000Writer.formatMDLInt(atomicMass, 3));
            this.writer.newLine();
        }
        if (rgroupList != null) {
            StringBuffer rgpLine = new StringBuffer();
            int cnt = 0;
            for (int i2 = 1; i2 <= rgroupList.size(); ++i2) {
                rgpLine.append(MDLV2000Writer.formatMDLInt((Integer)rgroupList.get(i2 - 1), 4));
                rgpLine.append(MDLV2000Writer.formatMDLInt((Integer)rgroupList.get(++i2 - 1), 4));
                ++cnt;
                if (i2 != rgroupList.size() && i2 != 16) continue;
                rgpLine.insert(0, "M  RGP" + MDLV2000Writer.formatMDLInt(cnt, 3));
                this.writer.write(rgpLine.toString());
                this.writer.newLine();
                rgpLine = new StringBuffer();
                cnt = 0;
            }
        }
        this.writer.write("M  END");
        this.writer.newLine();
        this.writer.flush();
    }

    protected static String formatMDLInt(int i, int l) {
        String s = "";
        String fs = "";
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setParseIntegerOnly(true);
        nf.setMinimumIntegerDigits(1);
        nf.setMaximumIntegerDigits(l);
        nf.setGroupingUsed(false);
        s = nf.format(i);
        l -= s.length();
        for (int f = 0; f < l; ++f) {
            fs = fs + " ";
        }
        fs = fs + s;
        return fs;
    }

    protected static String formatMDLFloat(float fl) {
        String s = "";
        String fs = "";
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setMinimumIntegerDigits(1);
        nf.setMaximumIntegerDigits(4);
        nf.setMinimumFractionDigits(4);
        nf.setMaximumFractionDigits(4);
        nf.setGroupingUsed(false);
        s = nf.format(fl);
        int l = 10 - s.length();
        for (int f = 0; f < l; ++f) {
            fs = fs + " ";
        }
        fs = fs + s;
        return fs;
    }

    protected static String formatMDLString(String s, int le) {
        if ((s = s.trim()).length() > le) {
            return s.substring(0, le);
        }
        int l = le - s.length();
        for (int f = 0; f < l; ++f) {
            s = s + " ";
        }
        return s;
    }

    private void initIOSettings() {
        this.forceWriteAs2DCoords = new BooleanIOSetting("ForceWriteAs2DCoordinates", 2, "Should coordinates always be written as 2D?", "false");
        this.writeAromaticBondTypes = new BooleanIOSetting("WriteAromaticBondTypes", 2, "Should aromatic bonds be written as bond type 4?", "false");
    }

    public void customizeJob() {
        this.fireIOSettingQuestion(this.forceWriteAs2DCoords);
        this.fireIOSettingQuestion(this.writeAromaticBondTypes);
    }

    @Override
    public IOSetting[] getIOSettings() {
        IOSetting[] settings = new IOSetting[]{this.forceWriteAs2DCoords, this.writeAromaticBondTypes};
        return settings;
    }
}

