#' Boiling Point Data
#'
#' A dataset containing the structures and associated boiling 
#' points for 277 molecules, primarily alkanes and substituted alkanes.
#'
#' @format A data frame with 277 rows and 2 columns.:
#' \describe{
#'   \item{SMILES}{Structure in SMILES format}
#'   \item{BP}{Boiling point in Kelvin}
#'   
#' } The names of the molecules are used as the row names.
#' 
#' @references 
#'  Goll, E.S. and Jurs, P.C.; "Prediction of the Normal Boiling Points of
#'  Organic Compounds From Molecular Structures with a Computational
#'  Neural Network Model", \emph{J. Chem. Inf. Comput. Sci.}, 1999, 
#'  \emph{39}, 974-983.
#'  
#' @docType data
"bpdata"

