/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Vector;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class ScriptManager {
    Viewer viewer;
    Thread queueThread;
    Vector scriptQueue = new Vector();
    boolean useQueue = true;
    boolean scriptQueueRunning;
    int level;

    ScriptManager(Viewer viewer) {
        this.viewer = viewer;
    }

    public void setQueue(boolean TF) {
        this.useQueue = TF;
        if (!TF) {
            this.clearQueue();
        }
    }

    public String addScript(String strScript) {
        return (String)this.addScript("string", strScript, "", false, false);
    }

    public String addScript(String strScript, boolean isScriptFile, boolean isQuiet) {
        return (String)this.addScript("String", strScript, "", isScriptFile, isQuiet);
    }

    public Object addScript(String returnType, String strScript, String statusList, boolean isScriptFile, boolean isQuiet) {
        Object tokenInfo = null;
        Vector<Object> scriptItem = new Vector<Object>();
        scriptItem.add(strScript);
        scriptItem.add(statusList);
        scriptItem.add(returnType);
        scriptItem.add(isScriptFile ? Boolean.TRUE : Boolean.FALSE);
        scriptItem.add(isQuiet ? Boolean.TRUE : Boolean.FALSE);
        scriptItem.add(tokenInfo);
        if (!this.useQueue) {
            this.clearQueue();
            this.viewer.haltScriptExecution();
        }
        this.scriptQueue.add(scriptItem);
        Logger.debug(this.scriptQueue.size() + " scripts; added: " + strScript);
        this.startScriptQueue();
        return "pending";
    }

    public int getScriptCount() {
        return this.scriptQueue.size();
    }

    public void clearQueue() {
        this.scriptQueue.clear();
    }

    public void waitForQueue() {
        int n = 0;
        while (this.queueThread != null) {
            try {
                Thread.sleep(100L);
                if (n++ % 10 != 0) continue;
                Logger.debug("...scriptManager waiting for queue: " + this.scriptQueue.size());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    Object runNextScript() {
        if (this.scriptQueue.size() == 0) {
            return null;
        }
        Vector scriptItem = (Vector)this.scriptQueue.get(0);
        String script = (String)scriptItem.get(0);
        String statusList = (String)scriptItem.get(1);
        String returnType = (String)scriptItem.get(2);
        boolean isScriptFile = (Boolean)scriptItem.get(3);
        boolean isQuiet = (Boolean)scriptItem.get(4);
        Vector tokenInfo = (Vector)scriptItem.get(5);
        Logger.debug(this.scriptQueue.size() + " scripts; running: " + script);
        this.scriptQueue.remove(0);
        Object returnInfo = this.runScript(returnType, script, statusList, isScriptFile, isQuiet, tokenInfo);
        if (this.scriptQueue.size() == 0) {
            return null;
        }
        return returnInfo;
    }

    private Object runScript(String returnType, String strScript, String statusList, boolean isScriptFile, boolean isQuiet, Vector tokenInfo) {
        return this.viewer.evalStringWaitStatus(returnType, strScript, statusList, isScriptFile, isQuiet, tokenInfo);
    }

    private void startScriptQueue() {
        if (this.scriptQueueRunning) {
            return;
        }
        this.scriptQueueRunning = true;
        this.queueThread = new Thread(new ScriptQueueRunnable());
        this.queueThread.start();
    }

    class ScriptQueueRunnable
    implements Runnable {
        ScriptQueueRunnable() {
        }

        public void run() {
            while (ScriptManager.this.scriptQueue.size() != 0) {
                ScriptManager.this.runNextScript();
            }
            ScriptManager.this.scriptQueueRunning = false;
            ScriptManager.this.queueThread = null;
        }

        public void stop() {
            ScriptManager.this.scriptQueueRunning = false;
        }
    }
}

