/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Structure;
import org.jmol.viewer.JmolConstants;

class CifReader
extends AtomSetCollectionReader {
    RidiculousFileFormatTokenizer tokenizer = new RidiculousFileFormatTokenizer();
    String thisDataSetName = "";
    String chemicalName = "";
    String thisStructuralFormula = "";
    String thisFormula = "";
    Hashtable htHetero;
    static final String[] cellParamNames = new String[]{"_cell_length_a", "_cell_length_b", "_cell_length_c", "_cell_angle_alpha", "_cell_angle_beta", "_cell_angle_gamma", "_cell.length_a", "_cell.length_b", "_cell.length_c", "_cell.angle_alpha", "_cell.angle_beta", "_cell.angle_gamma"};
    static final String[] TransformFields = new String[]{"x[1][1]", "x[1][2]", "x[1][3]", "r[1]", "x[2][1]", "x[2][2]", "x[2][3]", "r[2]", "x[3][1]", "x[3][2]", "x[3][3]", "r[3]"};
    String key;
    String data;
    Hashtable atomTypes;
    static final byte ATOM_TYPE_SYMBOL = 0;
    static final byte ATOM_TYPE_OXIDATION_NUMBER = 1;
    static final String[] atomTypeFields = new String[]{"_atom_type_symbol", "_atom_type_oxidation_number"};
    static final byte NONE = -1;
    static final byte TYPE_SYMBOL = 0;
    static final byte LABEL = 1;
    static final byte AUTH_ATOM = 2;
    static final byte FRACT_X = 3;
    static final byte FRACT_Y = 4;
    static final byte FRACT_Z = 5;
    static final byte CARTN_X = 6;
    static final byte CARTN_Y = 7;
    static final byte CARTN_Z = 8;
    static final byte OCCUPANCY = 9;
    static final byte B_ISO = 10;
    static final byte COMP_ID = 11;
    static final byte ASYM_ID = 12;
    static final byte SEQ_ID = 13;
    static final byte INS_CODE = 14;
    static final byte ALT_ID = 15;
    static final byte GROUP_PDB = 16;
    static final byte MODEL_NO = 17;
    static final byte DUMMY_ATOM = 18;
    static final byte DISORDER_GROUP = 19;
    static final String[] atomFields = new String[]{"_atom_site_type_symbol", "_atom_site_label", "_atom_site_auth_atom_id", "_atom_site_fract_x", "_atom_site_fract_y", "_atom_site_fract_z", "_atom_site.Cartn_x", "_atom_site.Cartn_y", "_atom_site.Cartn_z", "_atom_site_occupancy", "_atom_site.b_iso_or_equiv", "_atom_site.auth_comp_id", "_atom_site.auth_asym_id", "_atom_site.auth_seq_id", "_atom_site.pdbx_PDB_ins_code", "_atom_site.label_alt_id", "_atom_site.group_PDB", "_atom_site.pdbx_PDB_model_num", "_atom_site_calc_flag", "_atom_site_disorder_group"};
    static final byte GEOM_BOND_ATOM_SITE_LABEL_1 = 0;
    static final byte GEOM_BOND_ATOM_SITE_LABEL_2 = 1;
    static final byte GEOM_BOND_SITE_SYMMETRY_2 = 2;
    static final String[] geomBondFields = new String[]{"_geom_bond_atom_site_label_1", "_geom_bond_atom_site_label_2", "_geom_bond_site_symmetry_2"};
    static final byte NONPOLY_ENTITY_ID = 0;
    static final byte NONPOLY_NAME = 1;
    static final byte NONPOLY_COMP_ID = 2;
    static final String[] nonpolyFields = new String[]{"_pdbx_entity_nonpoly.entity_id", "_pdbx_entity_nonpoly.name", "_pdbx_entity_nonpoly.comp_id"};
    String[] hetatmData;
    static final byte CHEM_COMP_ID = 0;
    static final byte CHEM_COMP_NAME = 1;
    static final String[] chemCompFields = new String[]{"_chem_comp.id", "_chem_comp.name"};
    static final byte CONF_TYPE_ID = 0;
    static final byte BEG_ASYM_ID = 1;
    static final byte BEG_SEQ_ID = 2;
    static final byte BEG_INS_CODE = 3;
    static final byte END_ASYM_ID = 4;
    static final byte END_SEQ_ID = 5;
    static final byte END_INS_CODE = 6;
    static final String[] structConfFields = new String[]{"_struct_conf.conf_type_id", "_struct_conf.beg_auth_asym_id", "_struct_conf.beg_auth_seq_id", "_struct_conf.pdbx_beg_PDB_ins_code", "_struct_conf.end_auth_asym_id", "_struct_conf.end_auth_seq_id", "_struct_conf.pdbx_end_PDB_ins_code"};
    static final String[] structSheetRangeFields = new String[]{"_struct_sheet_range.sheet_id", "_struct_sheet_range.beg_auth_asym_id", "_struct_sheet_range.beg_auth_seq_id", "_struct_sheet_range.pdbx_beg_PDB_ins_code", "_struct_sheet_range.end_auth_asym_id", "_struct_sheet_range.end_auth_seq_id", "_struct_sheet_range.pdbx_end_PDB_ins_code"};
    static final byte SYMOP_XYZ = 0;
    static final byte SYM_EQUIV_XYZ = 1;
    static final String[] symmetryOperationsFields = new String[]{"_space_group_symop_operation_xyz", "_symmetry_equiv_pos_as_xyz"};
    String[] loopData;
    int[] fieldTypes = new int[100];
    boolean[] propertyReferenced = new boolean[50];
    int propertyCount;
    int fieldCount;

    CifReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        int nAtoms = 0;
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("cif");
        this.line = "";
        boolean skipping = false;
        while ((this.key = this.tokenizer.peekToken()) != null) {
            if (this.key.indexOf("#jmolscript:") >= 0) {
                this.checkLineForScript();
            }
            if (this.key.startsWith("data_")) {
                if (this.iHaveDesiredModel) break;
                boolean bl = skipping = ++this.modelNumber != this.desiredModelNumber && this.desiredModelNumber > 0;
                if (skipping) {
                    this.tokenizer.getTokenPeeked();
                    continue;
                }
                this.chemicalName = "";
                this.thisStructuralFormula = "";
                this.thisFormula = "";
                if (nAtoms == this.atomSetCollection.atomCount) {
                    this.atomSetCollection.removeAtomSet();
                } else {
                    this.applySymmetry();
                }
                this.processDataParameter();
                this.iHaveDesiredModel = this.desiredModelNumber > 0;
                nAtoms = this.atomSetCollection.atomCount;
                continue;
            }
            if (this.key.startsWith("loop_")) {
                if (skipping) {
                    this.tokenizer.getTokenPeeked();
                    continue;
                }
                this.processLoopBlock();
                continue;
            }
            if (this.key.indexOf("_") != 0) {
                this.logger.log("CIF ERROR ? should be an underscore: " + this.key);
                this.tokenizer.getTokenPeeked();
            } else if (!this.getData()) continue;
            if (skipping) continue;
            if (this.key.startsWith("_chemical_name")) {
                this.processChemicalInfo("name");
                continue;
            }
            if (this.key.startsWith("_chemical_formula_structural")) {
                this.processChemicalInfo("structuralFormula");
                continue;
            }
            if (this.key.startsWith("_chemical_formula_sum")) {
                this.processChemicalInfo("formula");
                continue;
            }
            if (this.key.startsWith("_cell_") || this.key.startsWith("_cell.")) {
                this.processCellParameter();
                continue;
            }
            if (this.key.startsWith("_symmetry_space_group_name_H-M") || this.key.startsWith("_symmetry.space_group_name_H-M") || this.key.startsWith("_symmetry_space_group_name_Hall") || this.key.startsWith("_symmetry.space_group_name_Hall")) {
                this.processSymmetrySpaceGroupName();
                continue;
            }
            if (this.key.startsWith("_atom_sites.fract_tran") || this.key.startsWith("_atom_sites.fract_tran")) {
                this.processUnitCellTransformMatrix();
                continue;
            }
            if (!this.key.startsWith("_pdbx_entity_nonpoly")) continue;
            this.processNonpolyData();
        }
        if (this.atomSetCollection.atomCount == nAtoms) {
            this.atomSetCollection.removeAtomSet();
        } else {
            this.applySymmetry();
        }
        this.atomSetCollection.setCollectionName("<collection of " + this.atomSetCollection.atomSetCount + " models>");
        return this.atomSetCollection;
    }

    void processDataParameter() {
        this.tokenizer.getTokenPeeked();
        String string = this.thisDataSetName = this.key.length() < 6 ? "" : this.key.substring(5);
        if (this.thisDataSetName.length() > 0) {
            if (this.atomSetCollection.currentAtomSetIndex >= 0) {
                this.atomSetCollection.newAtomSet();
            } else {
                this.atomSetCollection.setCollectionName(this.thisDataSetName);
            }
        }
        this.logger.log(this.key);
    }

    void processChemicalInfo(String type) throws Exception {
        if (type.equals("name")) {
            this.chemicalName = this.data = this.tokenizer.fullTrim(this.data);
        } else if (type.equals("structuralFormula")) {
            this.thisStructuralFormula = this.data = this.tokenizer.fullTrim(this.data);
        } else if (type.equals("formula")) {
            this.thisFormula = this.data = this.tokenizer.fullTrim(this.data);
        }
        this.logger.log(type + " = " + this.data);
    }

    void processSymmetrySpaceGroupName() throws Exception {
        this.setSpaceGroupName(this.data);
    }

    void processCellParameter() throws Exception {
        int i = cellParamNames.length;
        while (--i >= 0) {
            if (!CifReader.isMatch(this.key, cellParamNames[i])) continue;
            this.setUnitCellItem(i % 6, this.parseFloat(this.data));
            return;
        }
    }

    void processUnitCellTransformMatrix() throws Exception {
        float v = this.parseFloat(this.data);
        if (Float.isNaN(v)) {
            return;
        }
        for (int i = 0; i < TransformFields.length; ++i) {
            if (this.key.indexOf(TransformFields[i]) < 0) continue;
            this.setUnitCellItem(6 + i, v);
            return;
        }
    }

    boolean getData() throws Exception {
        this.key = this.tokenizer.getTokenPeeked();
        this.data = this.tokenizer.getNextToken();
        if (this.data == null) {
            this.logger.log("CIF ERROR ? end of file; data missing: " + this.key);
            return false;
        }
        return this.data.length() == 0 || this.data.charAt(0) != '\u0000';
    }

    private void processLoopBlock() throws Exception {
        this.tokenizer.getTokenPeeked();
        String str = this.tokenizer.peekToken();
        if (str == null) {
            return;
        }
        if (str.startsWith("_atom_site_") || str.startsWith("_atom_site.")) {
            if (!this.processAtomSiteLoopBlock()) {
                return;
            }
            this.atomSetCollection.setAtomSetName(this.thisDataSetName);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("chemicalName", this.chemicalName);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("structuralFormula", this.thisStructuralFormula);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("formula", this.thisFormula);
            return;
        }
        if (str.startsWith("_atom_type")) {
            this.processAtomTypeLoopBlock();
            return;
        }
        if (str.startsWith("_geom_bond")) {
            if (this.doApplySymmetry) {
                this.skipLoop();
            } else {
                this.processGeomBondLoopBlock();
            }
            return;
        }
        if (str.startsWith("_pdbx_entity_nonpoly")) {
            this.processNonpolyLoopBlock();
            return;
        }
        if (str.startsWith("_chem_comp")) {
            this.processChemCompLoopBlock();
            return;
        }
        if (str.startsWith("_struct_conf") && !str.startsWith("_struct_conf_type")) {
            this.processStructConfLoopBlock();
            return;
        }
        if (str.startsWith("_struct_sheet_range")) {
            this.processStructSheetRangeLoopBlock();
            return;
        }
        if (str.startsWith("_struct_sheet_range")) {
            this.processStructSheetRangeLoopBlock();
            return;
        }
        if (str.startsWith("_symmetry_equiv_pos") || str.startsWith("space_group_symop")) {
            if (this.ignoreFileSymmetryOperators) {
                this.logger.log("ignoring file-based symmetry operators");
                this.skipLoop();
            } else {
                this.processSymmetryOperationsLoopBlock();
            }
            return;
        }
        this.skipLoop();
    }

    void processAtomTypeLoopBlock() throws Exception {
        this.parseLoopParameters(atomTypeFields);
        int i = this.propertyCount;
        while (--i >= 0) {
            if (this.propertyReferenced[i]) continue;
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            String atomTypeSymbol = null;
            float oxidationNumber = Float.NaN;
            block7: for (int i2 = 0; i2 < this.fieldCount; ++i2) {
                char firstChar;
                String field = this.loopData[i2];
                if (field.length() == 0 || (firstChar = field.charAt(0)) == '\u0000') continue;
                switch (this.fieldTypes[i2]) {
                    case -1: {
                        continue block7;
                    }
                    case 0: {
                        atomTypeSymbol = field;
                        continue block7;
                    }
                    case 1: {
                        oxidationNumber = this.parseFloat(field);
                    }
                }
            }
            if (atomTypeSymbol == null || Float.isNaN(oxidationNumber)) continue;
            if (this.atomTypes == null) {
                this.atomTypes = new Hashtable();
            }
            this.atomTypes.put(atomTypeSymbol, new Float(oxidationNumber));
        }
    }

    boolean processAtomSiteLoopBlock() throws Exception {
        int currentModelNO = -1;
        boolean isPDB = false;
        this.parseLoopParameters(atomFields);
        if (this.propertyReferenced[6]) {
            this.setFractionalCoordinates(false);
            for (int i = 3; i < 5; ++i) {
                this.disableField(i);
            }
        } else if (this.propertyReferenced[3]) {
            this.setFractionalCoordinates(true);
            for (int i = 6; i < 8; ++i) {
                this.disableField(i);
            }
        } else {
            this.skipLoop();
            return false;
        }
        while (this.tokenizer.getData()) {
            Atom atom = new Atom();
            block21: for (int i = 0; i < this.fieldCount; ++i) {
                char firstChar;
                String field = this.loopData[i];
                if (field.length() == 0 || (firstChar = field.charAt(0)) == '\u0000') continue;
                switch (this.fieldTypes[i]) {
                    case -1: {
                        continue block21;
                    }
                    case 0: {
                        char ch1;
                        char ch0;
                        String elementSymbol = field.length() < 2 ? field : (Atom.isValidElementSymbol(ch0 = field.charAt(0), ch1 = Character.toLowerCase(field.charAt(1))) ? "" + ch0 + ch1 : "" + ch0);
                        atom.elementSymbol = elementSymbol;
                        if (this.atomTypes == null || !this.atomTypes.containsKey(field)) continue block21;
                        float charge = ((Float)this.atomTypes.get(field)).floatValue();
                        atom.formalCharge = (int)((double)charge + (charge < 0.0f ? -0.5 : 0.5));
                        if (!((double)Math.abs((float)atom.formalCharge - charge) > 0.1)) continue block21;
                        this.logger.log("CIF charge on " + field + " was " + charge + "; rounded to " + atom.formalCharge);
                        continue block21;
                    }
                    case 1: 
                    case 2: {
                        atom.atomName = field;
                        continue block21;
                    }
                    case 3: 
                    case 6: {
                        atom.x = this.parseFloat(field);
                        continue block21;
                    }
                    case 4: 
                    case 7: {
                        atom.y = this.parseFloat(field);
                        continue block21;
                    }
                    case 5: 
                    case 8: {
                        atom.z = this.parseFloat(field);
                        continue block21;
                    }
                    case 9: {
                        float floatOccupancy = this.parseFloat(field);
                        if (Float.isNaN(floatOccupancy)) continue block21;
                        atom.occupancy = (int)(floatOccupancy * 100.0f);
                        continue block21;
                    }
                    case 10: {
                        atom.bfactor = this.parseFloat(field);
                        continue block21;
                    }
                    case 11: {
                        atom.group3 = field;
                        continue block21;
                    }
                    case 12: {
                        if (field.length() > 1) {
                            this.logger.log("Don't know how to deal with chains more than 1 char", field);
                        }
                        atom.chainID = firstChar;
                        continue block21;
                    }
                    case 13: {
                        atom.sequenceNumber = this.parseInt(field);
                        continue block21;
                    }
                    case 14: {
                        atom.chainID = firstChar;
                        continue block21;
                    }
                    case 15: 
                    case 19: {
                        atom.alternateLocationID = field.charAt(0);
                        continue block21;
                    }
                    case 16: {
                        isPDB = true;
                        if (!"HETATM".equals(field)) continue block21;
                        atom.isHetero = true;
                        continue block21;
                    }
                    case 17: {
                        int modelNO = this.parseInt(field);
                        if (modelNO == currentModelNO) continue block21;
                        this.atomSetCollection.newAtomSet();
                        currentModelNO = modelNO;
                        continue block21;
                    }
                    case 18: {
                        if (!"dum".equals(field)) continue block21;
                        atom.x = Float.NaN;
                        continue block21;
                    }
                }
            }
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                this.logger.log("atom " + atom.atomName + " has invalid/unknown coordinates");
                continue;
            }
            this.setAtomCoord(atom);
            this.atomSetCollection.addAtomWithMappedName(atom);
            if (!atom.isHetero || this.htHetero == null) continue;
            this.atomSetCollection.setAtomSetAuxiliaryInfo("hetNames", this.htHetero);
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("hetNames", this.htHetero);
            this.htHetero = null;
        }
        if (isPDB) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("isPDB", new Boolean(isPDB));
            this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", new Boolean(isPDB));
        }
        return true;
    }

    void processGeomBondLoopBlock() throws Exception {
        this.parseLoopParameters(geomBondFields);
        int i = this.propertyCount;
        while (--i >= 0) {
            if (this.propertyReferenced[i]) continue;
            this.logger.log("?que? missing _geom_bond property:" + i);
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            int atomIndex1 = -1;
            int atomIndex2 = -1;
            String symmetry = null;
            block8: for (int i2 = 0; i2 < this.fieldCount; ++i2) {
                char firstChar;
                String field = this.loopData[i2];
                if (field.length() == 0 || (firstChar = field.charAt(0)) == '\u0000') continue;
                switch (this.fieldTypes[i2]) {
                    case -1: {
                        continue block8;
                    }
                    case 0: {
                        atomIndex1 = this.atomSetCollection.getAtomNameIndex(field);
                        continue block8;
                    }
                    case 1: {
                        atomIndex2 = this.atomSetCollection.getAtomNameIndex(field);
                        continue block8;
                    }
                    case 2: {
                        symmetry = field;
                    }
                }
            }
            if (symmetry != null || atomIndex1 < 0 || atomIndex2 < 0) continue;
            Bond bond = new Bond();
            bond.atomIndex1 = atomIndex1;
            bond.atomIndex2 = atomIndex2;
            this.atomSetCollection.addBond(bond);
        }
    }

    void processNonpolyData() {
        if (this.hetatmData == null) {
            this.hetatmData = new String[3];
        }
        int i = nonpolyFields.length;
        while (--i >= 0) {
            if (!CifReader.isMatch(this.key, nonpolyFields[i])) continue;
            this.hetatmData[i] = this.data;
            break;
        }
        if (this.hetatmData[1] == null || this.hetatmData[2] == null) {
            return;
        }
        this.addHetero(this.hetatmData[2], this.hetatmData[1]);
        this.hetatmData = null;
    }

    void processChemCompLoopBlock() throws Exception {
        this.parseLoopParameters(chemCompFields);
        while (this.tokenizer.getData()) {
            String groupName = null;
            String hetName = null;
            block6: for (int i = 0; i < this.fieldCount; ++i) {
                char firstChar;
                String field = this.loopData[i];
                if (field.length() == 0 || (firstChar = field.charAt(0)) == '\u0000') continue;
                switch (this.fieldTypes[i]) {
                    case -1: {
                        continue block6;
                    }
                    case 0: {
                        groupName = field;
                        continue block6;
                    }
                    case 1: {
                        hetName = field;
                    }
                }
            }
            if (groupName == null || hetName == null) {
                return;
            }
            this.addHetero(groupName, hetName);
        }
    }

    void processNonpolyLoopBlock() throws Exception {
        this.parseLoopParameters(nonpolyFields);
        while (this.tokenizer.getData()) {
            String groupName = null;
            String hetName = null;
            block6: for (int i = 0; i < this.fieldCount; ++i) {
                char firstChar;
                String field = this.loopData[i];
                if (field.length() == 0 || (firstChar = field.charAt(0)) == '\u0000') continue;
                switch (this.fieldTypes[i]) {
                    case -1: 
                    case 0: {
                        continue block6;
                    }
                    case 2: {
                        groupName = field;
                        continue block6;
                    }
                    case 1: {
                        hetName = field;
                    }
                }
            }
            if (groupName == null || hetName == null) {
                return;
            }
            this.addHetero(groupName, hetName);
        }
    }

    void addHetero(String groupName, String hetName) {
        if (!JmolConstants.isHetero(groupName)) {
            return;
        }
        if (this.htHetero == null) {
            this.htHetero = new Hashtable();
        }
        this.htHetero.put(groupName, hetName);
        this.logger.log("hetero: " + groupName + " = " + hetName);
    }

    void processStructConfLoopBlock() throws Exception {
        this.parseLoopParameters(structConfFields);
        int i = this.propertyCount;
        while (--i >= 0) {
            if (this.propertyReferenced[i]) continue;
            this.logger.log("?que? missing _struct_conf property:" + i);
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            Structure structure = new Structure();
            block12: for (int i2 = 0; i2 < this.fieldCount; ++i2) {
                char firstChar;
                String field = this.loopData[i2];
                if (field.length() == 0 || (firstChar = field.charAt(0)) == '\u0000') continue;
                switch (this.fieldTypes[i2]) {
                    case -1: {
                        continue block12;
                    }
                    case 0: {
                        if (field.startsWith("HELX")) {
                            structure.structureType = "helix";
                            continue block12;
                        }
                        if (field.startsWith("TURN")) {
                            structure.structureType = "turn";
                            continue block12;
                        }
                        structure.structureType = "none";
                        continue block12;
                    }
                    case 1: {
                        structure.startChainID = firstChar;
                        continue block12;
                    }
                    case 2: {
                        structure.startSequenceNumber = this.parseInt(field);
                        continue block12;
                    }
                    case 3: {
                        structure.startInsertionCode = firstChar;
                        continue block12;
                    }
                    case 4: {
                        structure.endChainID = firstChar;
                        continue block12;
                    }
                    case 5: {
                        structure.endSequenceNumber = this.parseInt(field);
                        continue block12;
                    }
                    case 6: {
                        structure.endInsertionCode = firstChar;
                    }
                }
            }
            this.atomSetCollection.addStructure(structure);
        }
    }

    void processStructSheetRangeLoopBlock() throws Exception {
        this.parseLoopParameters(structSheetRangeFields);
        int i = this.propertyCount;
        while (--i >= 0) {
            if (this.propertyReferenced[i]) continue;
            this.logger.log("?que? missing _struct_conf property:" + i);
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            Structure structure = new Structure();
            structure.structureType = "sheet";
            block10: for (int i2 = 0; i2 < this.fieldCount; ++i2) {
                char firstChar;
                String field = this.loopData[i2];
                if (field.length() == 0 || (firstChar = field.charAt(0)) == '\u0000') continue;
                switch (this.fieldTypes[i2]) {
                    case 1: {
                        structure.startChainID = firstChar;
                        continue block10;
                    }
                    case 2: {
                        structure.startSequenceNumber = this.parseInt(field);
                        continue block10;
                    }
                    case 3: {
                        structure.startInsertionCode = firstChar;
                        continue block10;
                    }
                    case 4: {
                        structure.endChainID = firstChar;
                        continue block10;
                    }
                    case 5: {
                        structure.endSequenceNumber = this.parseInt(field);
                        continue block10;
                    }
                    case 6: {
                        structure.endInsertionCode = firstChar;
                    }
                }
            }
            this.atomSetCollection.addStructure(structure);
        }
    }

    void processSymmetryOperationsLoopBlock() throws Exception {
        this.parseLoopParameters(symmetryOperationsFields);
        int nRefs = 0;
        int i = this.propertyCount;
        while (--i >= 0) {
            if (!this.propertyReferenced[i]) continue;
            ++nRefs;
        }
        if (nRefs != 1) {
            this.logger.log("?que? _symmetry_equiv or _space_group_symop property not found");
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            for (i = 0; i < this.fieldCount; ++i) {
                char firstChar;
                String field = this.loopData[i];
                if (field.length() == 0 || (firstChar = field.charAt(0)) == '\u0000') continue;
                switch (this.fieldTypes[i]) {
                    case 0: 
                    case 1: {
                        this.setSymmetryOperator(field);
                    }
                }
            }
        }
    }

    void parseLoopParameters(String[] fields) throws Exception {
        this.fieldCount = 0;
        for (int i = 0; i < fields.length; ++i) {
            this.propertyReferenced[i] = false;
        }
        this.propertyCount = fields.length;
        while (true) {
            String str;
            if ((str = this.tokenizer.peekToken()) == null) {
                this.fieldCount = 0;
                break;
            }
            if (str.charAt(0) != '_') break;
            this.tokenizer.getTokenPeeked();
            this.fieldTypes[this.fieldCount] = -1;
            int i = fields.length;
            while (--i >= 0) {
                if (!CifReader.isMatch(str, fields[i])) continue;
                this.fieldTypes[this.fieldCount] = i;
                this.propertyReferenced[i] = true;
                break;
            }
            ++this.fieldCount;
        }
        if (this.fieldCount > 0) {
            this.loopData = new String[this.fieldCount];
        }
    }

    void disableField(int fieldIndex) {
        int i = this.fieldCount;
        while (--i >= 0) {
            if (this.fieldTypes[i] != fieldIndex) continue;
            this.fieldTypes[i] = -1;
        }
    }

    private void skipLoop() throws Exception {
        String str;
        while ((str = this.tokenizer.peekToken()) != null && str.charAt(0) == '_') {
            str = this.tokenizer.getTokenPeeked();
        }
        while (this.tokenizer.getNextDataToken() != null) {
        }
    }

    static final boolean isMatch(String str1, String str2) {
        int cch = str1.length();
        if (str2.length() != cch) {
            return false;
        }
        int i = cch;
        while (--i >= 0) {
            char ch2;
            char ch1 = str1.charAt(i);
            if (ch1 == (ch2 = str2.charAt(i)) || (ch1 == '_' || ch1 == '.') && (ch2 == '_' || ch2 == '.')) continue;
            if (ch1 <= 'Z' && ch1 >= 'A') {
                ch1 = (char)(ch1 + 32);
            } else if (ch2 <= 'Z' && ch2 >= 'A') {
                ch2 = (char)(ch2 + 32);
            }
            if (ch1 == ch2) continue;
            return false;
        }
        return true;
    }

    class RidiculousFileFormatTokenizer {
        String str;
        int ich;
        int cch;
        boolean wasUnQuoted;
        String strPeeked;
        int ichPeeked;

        RidiculousFileFormatTokenizer() {
        }

        void setString(String str) {
            this.str = str;
            this.cch = str == null ? 0 : str.length();
            this.ich = 0;
        }

        String setStringNextLine() throws Exception {
            this.setString(CifReader.this.readLine());
            if (CifReader.this.line == null || CifReader.this.line.length() == 0 || CifReader.this.line.charAt(0) != ';') {
                return CifReader.this.line;
            }
            this.ich = 1;
            String str = '\u0001' + CifReader.this.line.substring(1) + '\n';
            while (CifReader.this.readLine() != null) {
                if (CifReader.this.line.startsWith(";")) {
                    str = str.substring(0, str.length() - 1) + '\u0001' + CifReader.this.line.substring(1);
                    break;
                }
                str = str + CifReader.this.line + '\n';
            }
            this.setString(str);
            CifReader.this.line = str;
            return CifReader.this.line;
        }

        boolean hasMoreTokens() {
            if (this.str == null) {
                return false;
            }
            int ch = 35;
            while (this.ich < this.cch) {
                char c = this.str.charAt(this.ich);
                ch = c;
                if (c != ' ' && ch != 9) break;
                ++this.ich;
            }
            return this.ich < this.cch && ch != 35;
        }

        String nextToken() {
            if (this.ich == this.cch) {
                return null;
            }
            int ichStart = this.ich;
            char ch = this.str.charAt(ichStart);
            if (ch != '\'' && ch != '\"' && ch != '\u0001') {
                this.wasUnQuoted = true;
                while (this.ich < this.cch && (ch = this.str.charAt(this.ich)) != ' ' && ch != '\t') {
                    ++this.ich;
                }
                if (this.ich == ichStart + 1 && (this.str.charAt(ichStart) == '.' || this.str.charAt(ichStart) == '?')) {
                    return "\u0000";
                }
                return this.str.substring(ichStart, this.ich);
            }
            this.wasUnQuoted = false;
            char chOpeningQuote = ch;
            boolean previousCharacterWasQuote = false;
            while (++this.ich < this.cch) {
                ch = this.str.charAt(this.ich);
                if (previousCharacterWasQuote && (ch == ' ' || ch == '\t')) break;
                previousCharacterWasQuote = ch == chOpeningQuote;
            }
            if (this.ich == this.cch) {
                if (previousCharacterWasQuote) {
                    return this.str.substring(ichStart + 1, this.ich - 1);
                }
                return this.str.substring(ichStart, this.ich);
            }
            ++this.ich;
            return this.str.substring(ichStart + 1, this.ich - 2);
        }

        boolean wasUnQuoted() {
            return this.wasUnQuoted;
        }

        boolean getData() throws Exception {
            for (int i = 0; i < CifReader.this.fieldCount; ++i) {
                String str = this.getNextDataToken();
                if (str == null) {
                    return false;
                }
                CifReader.this.loopData[i] = str;
            }
            return true;
        }

        String getNextDataToken() throws Exception {
            String str = this.peekToken();
            if (str == null) {
                return null;
            }
            if (this.wasUnQuoted() && (str.charAt(0) == '_' || str.startsWith("loop_") || str.startsWith("data_") || str.startsWith("stop_") || str.startsWith("global_"))) {
                return null;
            }
            return CifReader.this.tokenizer.getTokenPeeked();
        }

        String getNextToken() throws Exception {
            while (!this.hasMoreTokens()) {
                if (this.setStringNextLine() != null) continue;
                return null;
            }
            return this.nextToken();
        }

        String peekToken() throws Exception {
            while (!this.hasMoreTokens()) {
                if (this.setStringNextLine() != null) continue;
                return null;
            }
            int ich = this.ich;
            this.strPeeked = this.nextToken();
            this.ichPeeked = this.ich;
            this.ich = ich;
            return this.strPeeked;
        }

        String getTokenPeeked() {
            this.ich = this.ichPeeked;
            return this.strPeeked;
        }

        String fullTrim(String str) {
            int pt0;
            int pt1 = str.length();
            for (pt0 = 0; pt0 < pt1 && "\n\t ".indexOf(str.charAt(pt0)) >= 0; ++pt0) {
            }
            while (pt0 < pt1 && "\n\t ".indexOf(str.charAt(pt1 - 1)) >= 0) {
                --pt1;
            }
            return str.substring(pt0, pt1);
        }
    }
}

