% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findvar.R
\name{findvar}
\alias{findvar}
\alias{findvar_anywhere}
\alias{findvar_fun}
\alias{findvar_in_df}
\title{Find variables by name}
\usage{
findvar_fun(df, ...)

findvar_in_df(pattern, df, ...)

findvar_anywhere(pattern, envir = .GlobalEnv, ...)
}
\arguments{
\item{df}{A data.frame from where the column names should be identified when returned function applied}

\item{...}{Arguments passed to \code{grep}}

\item{pattern}{A character string with name (or part of name) of the variables to find.}

\item{envir}{environment holding data.frames where to search for the variables (the Global environment as default).}
}
\value{
\itemize{
\item \code{findvar_fun}: A function with argument \code{param} to search for \code{param} in \code{df}. See example!
\item \code{findvar_in_df}: A vector with variable names from df matching the pattern.
\item \code{findvar_anywhere}: Does not return anything but prints a message where variables matching the pattern can be found.
}
}
\description{
Function to seacrh for a variable by its name. See the "Value" section for more details on the different functions.
}
\examples{
find_cars <- findvar_fun(cars)
find_cars("sp")

findvar_in_df("sp", cars)

cars <- cars; iris <- iris
findvar_anywhere("petal")
}

